/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.constraint;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.validation.base.ConstraintRule;
import io.rxmicro.validation.validator.IPConstraintValidator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@ConstraintRule(supportedTypes={String.class}, validatorClass={IPConstraintValidator.class})
public @interface IP {
    public boolean off() default false;

    public Version[] value() default {Version.IP_V4, Version.IP_V6};

    public static enum Version {
        IP_V4("ipv4", 4),
        IP_V6("ipv6", 6);

        private final String jsonFormat;
        private final int version;

        private Version(String jsonFormat, int version) {
            this.jsonFormat = jsonFormat;
            this.version = version;
        }

        public String getJsonFormat() {
            return this.jsonFormat;
        }

        public int getVersion() {
            return this.version;
        }

        public ReadMore getReadMore() {
            try {
                return ((Object)((Object)this)).getClass().getDeclaredField(this.name()).getAnnotation(ReadMore.class);
            }
            catch (NoSuchFieldException ex) {
                throw new ImpossibleException((Throwable)ex, "ReadMore must be present", new Object[0]);
            }
        }
    }
}

