/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.constraint;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.validation.base.ConstraintRule;
import io.rxmicro.validation.validator.CountryCodeConstraintValidator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;

@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@ConstraintRule(supportedTypes={String.class}, validatorClass={CountryCodeConstraintValidator.class})
public @interface CountryCode {
    public boolean off() default false;

    public Format format() default Format.ISO_3166_1_ALPHA_2;

    public static enum Format {
        ISO_3166_1_ALPHA_2("Two-letter country code according to ISO 3166-1 alpha2 standard."),
        ISO_3166_1_ALPHA_3("Three-letter country code according to ISO 3166-1 alpha3 standard."),
        ISO_3166_1_NUMERIC("Three-digit country code according to ISO 3166-1 numeric standard.");

        private static final int ISO_3166_1_PREFIX_LENGTH = 11;
        private final String description;

        private Format(String description) {
            this.description = description;
        }

        public String getType() {
            return this.name().substring(11).toLowerCase(Locale.ENGLISH).replace("_", "-");
        }

        public String getDescription() {
            return this.description;
        }

        public ReadMore getReadMore() {
            try {
                return ((Object)((Object)this)).getClass().getDeclaredField(this.name()).getAnnotation(ReadMore.class);
            }
            catch (NoSuchFieldException ex) {
                throw new ImpossibleException((Throwable)ex, "ReadMore must be present", new Object[0]);
            }
        }
    }
}

