/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.constraint;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.meta.ReadMore;
import io.rxmicro.validation.base.ConstraintRule;
import io.rxmicro.validation.validator.Base64URLEncodedConstraintValidator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@ConstraintRule(supportedTypes={String.class}, validatorClass={Base64URLEncodedConstraintValidator.class})
@ReadMore(caption="What is Base64 Encoding?", link="https://tools.ietf.org/html/rfc4648#section-4")
public @interface Base64URLEncoded {
    public boolean off() default false;

    public Alphabet alphabet() default Alphabet.URL;

    public static enum Alphabet {
        BASE,
        URL;


        public ReadMore getReadMore() {
            try {
                return ((Object)((Object)this)).getClass().getDeclaredField(this.name()).getAnnotation(ReadMore.class);
            }
            catch (NoSuchFieldException ex) {
                throw new ImpossibleException((Throwable)ex, "ReadMore must be present", new Object[0]);
            }
        }
    }
}

