/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.base;

public abstract class AbstractDateTimeEqualsConstraintValidator {
    protected static final int TRUNCATED_MILLISECONDS = 1000;
    protected static final int TRUNCATED_SECONDS = 60000;
    protected static final int TRUNCATED_MINUTES = 3600000;
    protected static final int TRUNCATED_HOURS = 86400000;
    private static final int[] TRUNCATED_CHARACTERISTICS = new int[]{1000, 60000, 3600000, 86400000};

    protected boolean isNotEqualsAfterTruncation(long expectedDirtyTimeInMillis, long actualClearTimeInMillis) {
        long expectedClearTimeInMillis = expectedDirtyTimeInMillis;
        for (int characteristic : TRUNCATED_CHARACTERISTICS) {
            if (actualClearTimeInMillis % (long)characteristic != 0L) break;
            expectedClearTimeInMillis = expectedDirtyTimeInMillis / (long)characteristic * (long)characteristic;
        }
        return expectedClearTimeInMillis != actualClearTimeInMillis;
    }
}

