/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit.local;

import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.util.List;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class TestObjects {
    public static Class<?> getOwnerTestClass(ExtensionContext context) {
        Class<?> testClass = context.getRequiredTestClass();
        if (testClass.isMemberClass()) {
            if (testClass.isAnnotationPresent(Nested.class)) {
                if ((testClass = testClass.getDeclaringClass()).isAnnotationPresent(Nested.class)) {
                    throw new InvalidTestConfigException("Supported ? classes with level 1 only!", new Object[]{Nested.class.getName()});
                }
            } else {
                throw new InvalidTestConfigException("Missing '?' annotation for '?' class", new Object[]{Nested.class.getName(), testClass.getName()});
            }
        }
        return testClass;
    }

    public static List<Object> getTestInstances(ExtensionContext context) {
        Object testInstance = context.getRequiredTestInstance();
        if (testInstance.getClass().isMemberClass()) {
            return List.of(testInstance, Reflections.getFieldValue((Object)testInstance, (String)"this$0"));
        }
        return List.of(testInstance);
    }

    private TestObjects() {
    }
}

