/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit.internal;

import io.rxmicro.cdi.BeanFactory;
import io.rxmicro.config.Config;
import io.rxmicro.config.local.DefaultConfigValueBuilderReSetter;
import io.rxmicro.netty.runtime.local.EventLoopGroupFactory;
import io.rxmicro.rest.server.HttpServerConfig;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.local.component.RestServerLauncher;
import io.rxmicro.rest.server.local.model.ServerContainer;
import io.rxmicro.runtime.AutoRelease;
import io.rxmicro.runtime.local.AbstractFactory;
import io.rxmicro.runtime.local.InstanceContainer;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.HttpServers;
import io.rxmicro.test.junit.RxMicroRestBasedMicroServiceTest;
import io.rxmicro.test.junit.internal.AbstractJUnitTestExtension;
import io.rxmicro.test.junit.local.TestObjects;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.UnNamedModuleFixers;
import io.rxmicro.test.local.component.ConfigResolver;
import io.rxmicro.test.local.component.RestControllerInstanceResolver;
import io.rxmicro.test.local.component.StatelessComponentFactory;
import io.rxmicro.test.local.component.builder.TestModelBuilder;
import io.rxmicro.test.local.component.injector.BeanFactoryInjector;
import io.rxmicro.test.local.component.injector.BlockingHttpClientInjector;
import io.rxmicro.test.local.component.injector.InjectorFactory;
import io.rxmicro.test.local.component.injector.RepositoryInjector;
import io.rxmicro.test.local.component.injector.RestClientInjector;
import io.rxmicro.test.local.component.injector.RuntimeContextComponentInjector;
import io.rxmicro.test.local.component.injector.SystemStreamInjector;
import io.rxmicro.test.local.component.injector.UserCreatedComponentInjector;
import io.rxmicro.test.local.component.validator.RestBasedMicroServiceTestValidator;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.Annotations;
import io.rxmicro.test.local.util.Modules;
import io.rxmicro.test.local.util.Safes;
import io.rxmicro.test.local.util.TestExceptions;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class RxMicroRestBasedMicroServiceTestExtension
extends AbstractJUnitTestExtension
implements BeforeAllCallback,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterEachCallback,
AfterAllCallback {
    private final RestBasedMicroServiceTestValidator restBasedMicroServiceTestValidator = new RestBasedMicroServiceTestValidator(SUPPORTED_TEST_ANNOTATIONS);
    private RestControllerInstanceResolver restControllerInstanceResolver;
    private BlockingHttpClient blockingHttpClient;
    private RuntimeContextComponentInjector runtimeContextComponentInjector;
    private RepositoryInjector repositoryInjector;
    private RestClientInjector restClientInjector;
    private BlockingHttpClientInjector blockingHttpClientInjector;
    private SystemStreamInjector systemStreamInjector;
    private UserCreatedComponentInjector userCreatedComponentInjector;
    private BeanFactoryInjector beanFactoryInjector;
    private ServerContainer serverContainer;
    private boolean waitForTestHttpServerStopped;

    public void beforeAll(ExtensionContext context) {
        Class<?> testClass = TestObjects.getOwnerTestClass(context);
        RxMicroRestBasedMicroServiceTest annotation = (RxMicroRestBasedMicroServiceTest)Annotations.getRequiredAnnotation(testClass, RxMicroRestBasedMicroServiceTest.class);
        this.waitForTestHttpServerStopped = annotation.waitForTestHttpServerStopped();
        Class[] restControllerClasses = annotation.value();
        this.validateNotEmptyArray(restControllerClasses);
        TestModelBuilder testModelBuilder = new TestModelBuilder(Modules.isRequiredModule((Module)restControllerClasses[0].getModule(), (Module)BeanFactory.class.getModule()));
        TestModel testModel = testModelBuilder.build(testClass);
        this.restBasedMicroServiceTestValidator.validate(testModel, restControllerClasses);
        int randomFreePort = HttpServers.getRandomFreePort();
        ConfigResolver configResolver = StatelessComponentFactory.getConfigResolver();
        configResolver.setDefaultConfigValues(testClass);
        Map configs = configResolver.getStaticConfigMap(testModel, new Config[]{new HttpServerConfig().setPort(randomFreePort).setStartTimeTrackerEnabled(false), new RestServerConfig().setDevelopmentMode(true)});
        this.serverContainer = RestServerLauncher.launchWithoutRestControllers((Map)configs);
        this.restControllerInstanceResolver = new RestControllerInstanceResolver(restControllerClasses, this.serverContainer);
        this.createInjectors(testClass, testModel, configs);
    }

    private void validateNotEmptyArray(Class<?> ... restControllerClasses) {
        if (restControllerClasses.length == 0) {
            throw new InvalidTestConfigException("Annotation '?' must contain at least one REST controller class", new Object[]{RxMicroRestBasedMicroServiceTest.class.getName()});
        }
    }

    private void createInjectors(Class<?> testClass, TestModel testModel, Map<String, Config> configs) {
        InjectorFactory injectorFactory = new InjectorFactory(testModel);
        this.blockingHttpClientInjector = injectorFactory.createBlockingHttpClientInjector();
        this.systemStreamInjector = injectorFactory.createSystemOutInjector();
        if (this.blockingHttpClientInjector.hasField()) {
            int serverPort = StatelessComponentFactory.getServerPortHelper().getServerPort(configs.values());
            BlockingHttpClientConfig config = this.blockingHttpClientInjector.getConfig(testClass, false, serverPort);
            this.restBasedMicroServiceTestValidator.validate(testModel, config);
            this.blockingHttpClient = StatelessComponentFactory.getBlockingHttpClientBuilder().build(config);
        }
        this.runtimeContextComponentInjector = injectorFactory.createRuntimeContextComponentInjector();
        this.userCreatedComponentInjector = injectorFactory.createUserCreatedComponentInjector();
        this.beanFactoryInjector = injectorFactory.createBeanFactoryInjector();
        this.repositoryInjector = injectorFactory.createRepositoryInjector();
        this.restClientInjector = injectorFactory.createRestClientInjector();
    }

    public void beforeEach(ExtensionContext context) {
        List<Object> testInstances = TestObjects.getTestInstances(context);
        this.runtimeContextComponentInjector.injectIfFound(testInstances);
        this.repositoryInjector.injectIfFound(testInstances);
        this.restClientInjector.injectIfFound(testInstances);
        this.beanFactoryInjector.injectIfFound(testInstances);
        this.blockingHttpClientInjector.injectIfFound(testInstances, this.blockingHttpClient);
        this.systemStreamInjector.injectIfFound(testInstances);
    }

    public void beforeTestExecution(ExtensionContext context) {
        List<Object> testInstances = TestObjects.getTestInstances(context);
        this.getBeforeTestInvoker().invokeIfFound(context, testInstances);
        this.serverContainer.register(this.restControllerInstanceResolver.getRestControllerClasses());
        try {
            this.userCreatedComponentInjector.injectIfFound(testInstances, this.restControllerInstanceResolver.getRestControllerInstances());
        }
        catch (InaccessibleObjectException ex) {
            TestExceptions.reThrowInaccessibleObjectException((InaccessibleObjectException)ex);
        }
    }

    public void afterEach(ExtensionContext context) {
        InstanceContainer.clearContainer();
        AbstractFactory.clearFactories();
        DefaultConfigValueBuilderReSetter.resetDefaultConfigValueStorage();
        this.resetConfigurationIfPossible();
        this.serverContainer.unregisterAllRestControllers();
        this.systemStreamInjector.resetIfNecessary();
    }

    public void afterAll(ExtensionContext context) {
        Safes.safeInvoke((Object)this.blockingHttpClient, AutoRelease::release);
        if (this.waitForTestHttpServerStopped) {
            Safes.safeInvoke((Object)this.serverContainer, container -> container.getServerInstance().shutdownAndWait());
        } else {
            Safes.safeInvoke((Object)this.serverContainer, container -> container.getServerInstance().shutdown());
        }
        EventLoopGroupFactory.clearEventLoopGroupFactory();
    }

    static {
        UnNamedModuleFixers.restBasedMicroServiceTestsFix();
    }
}

