/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit.internal;

import io.rxmicro.config.local.DefaultConfigValueBuilderReSetter;
import io.rxmicro.netty.runtime.local.EventLoopGroupFactory;
import io.rxmicro.runtime.local.AbstractFactory;
import io.rxmicro.runtime.local.InstanceContainer;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.junit.RxMicroIntegrationTest;
import io.rxmicro.test.junit.internal.AbstractJUnitTestExtension;
import io.rxmicro.test.junit.local.TestObjects;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import io.rxmicro.test.local.UnNamedModuleFixers;
import io.rxmicro.test.local.component.StatelessComponentFactory;
import io.rxmicro.test.local.component.builder.TestModelBuilder;
import io.rxmicro.test.local.component.injector.BlockingHttpClientInjector;
import io.rxmicro.test.local.component.injector.InjectorFactory;
import io.rxmicro.test.local.component.injector.SystemStreamInjector;
import io.rxmicro.test.local.component.validator.IntegrationTestValidator;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.Annotations;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class RxMicroIntegrationTestExtension
extends AbstractJUnitTestExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private BlockingHttpClient blockingHttpClient;
    private BlockingHttpClientInjector blockingHttpClientInjector;
    private SystemStreamInjector systemStreamInjector;

    public void beforeAll(ExtensionContext context) {
        Class<?> testClass = TestObjects.getOwnerTestClass(context);
        Annotations.getRequiredAnnotation(testClass, RxMicroIntegrationTest.class);
        TestModel testModel = new TestModelBuilder(false).build(testClass);
        IntegrationTestValidator integrationTestValidator = new IntegrationTestValidator(SUPPORTED_TEST_ANNOTATIONS);
        integrationTestValidator.validate(testModel);
        InjectorFactory injectorFactory = new InjectorFactory(testModel);
        this.blockingHttpClientInjector = injectorFactory.createBlockingHttpClientInjector();
        this.systemStreamInjector = injectorFactory.createSystemOutInjector();
        if (this.blockingHttpClientInjector.hasField()) {
            BlockingHttpClientConfig config = this.blockingHttpClientInjector.getConfig(testClass, true, 8080);
            integrationTestValidator.validate(testModel, config);
            this.blockingHttpClient = StatelessComponentFactory.getBlockingHttpClientBuilder().build(config);
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.getBeforeTestInvoker().throwErrorIfFound(context);
        List<Object> testInstances = TestObjects.getTestInstances(context);
        this.blockingHttpClientInjector.injectIfFound(testInstances, this.blockingHttpClient);
        this.systemStreamInjector.injectIfFound(testInstances);
    }

    public void afterEach(ExtensionContext context) {
        this.systemStreamInjector.resetIfNecessary();
    }

    public void afterAll(ExtensionContext context) {
        InstanceContainer.clearContainer();
        AbstractFactory.clearFactories();
        DefaultConfigValueBuilderReSetter.resetDefaultConfigValueStorage();
        EventLoopGroupFactory.clearEventLoopGroupFactory();
        this.resetConfigurationIfPossible();
    }

    static {
        UnNamedModuleFixers.integrationTestsFix();
    }
}

