/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit.internal;

import io.rxmicro.cdi.BeanFactory;
import io.rxmicro.config.Config;
import io.rxmicro.config.Configs;
import io.rxmicro.config.local.DefaultConfigValueBuilderReSetter;
import io.rxmicro.netty.runtime.local.EventLoopGroupFactory;
import io.rxmicro.runtime.local.AbstractFactory;
import io.rxmicro.runtime.local.InstanceContainer;
import io.rxmicro.test.junit.RxMicroComponentTest;
import io.rxmicro.test.junit.internal.AbstractJUnitTestExtension;
import io.rxmicro.test.junit.local.TestObjects;
import io.rxmicro.test.local.UnNamedModuleFixers;
import io.rxmicro.test.local.component.StatelessComponentFactory;
import io.rxmicro.test.local.component.TestedComponentResolver;
import io.rxmicro.test.local.component.builder.TestModelBuilder;
import io.rxmicro.test.local.component.injector.BeanFactoryInjector;
import io.rxmicro.test.local.component.injector.InjectorFactory;
import io.rxmicro.test.local.component.injector.RepositoryInjector;
import io.rxmicro.test.local.component.injector.RestClientInjector;
import io.rxmicro.test.local.component.injector.RuntimeContextComponentInjector;
import io.rxmicro.test.local.component.injector.SystemStreamInjector;
import io.rxmicro.test.local.component.injector.UserCreatedComponentInjector;
import io.rxmicro.test.local.component.validator.ComponentTestValidator;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.Annotations;
import io.rxmicro.test.local.util.Modules;
import io.rxmicro.test.local.util.TestExceptions;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class RxMicroComponentTestExtension
extends AbstractJUnitTestExtension
implements BeforeAllCallback,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterEachCallback,
AfterAllCallback {
    private TestModel testModel;
    private RepositoryInjector repositoryInjector;
    private RestClientInjector restClientInjector;
    private RuntimeContextComponentInjector runtimeContextComponentInjector;
    private UserCreatedComponentInjector userCreatedComponentInjector;
    private BeanFactoryInjector beanFactoryInjector;
    private TestedComponentResolver testedComponentResolver;
    private SystemStreamInjector systemStreamInjector;

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        Class<?> componentClass = ((RxMicroComponentTest)Annotations.getRequiredAnnotation((Class)testClass, RxMicroComponentTest.class)).value();
        TestModelBuilder testModelBuilder = new TestModelBuilder(componentClass, Modules.isRequiredModule((Module)componentClass.getModule(), (Module)BeanFactory.class.getModule()));
        this.testModel = testModelBuilder.build(testClass);
        new ComponentTestValidator(SUPPORTED_TEST_ANNOTATIONS).validate(this.testModel);
        StatelessComponentFactory.getConfigResolver().setDefaultConfigValues(testClass);
        if (this.testModel.isStaticConfigsPresent()) {
            new Configs.Builder().withConfigs(StatelessComponentFactory.getConfigResolver().getStaticConfigMap(this.testModel, new Config[0])).build();
        } else {
            new Configs.Builder().buildIfNotConfigured();
        }
        InjectorFactory injectorFactory = new InjectorFactory(this.testModel);
        this.repositoryInjector = injectorFactory.createRepositoryInjector();
        this.restClientInjector = injectorFactory.createRestClientInjector();
        this.runtimeContextComponentInjector = injectorFactory.createRuntimeContextComponentInjector();
        this.userCreatedComponentInjector = injectorFactory.createUserCreatedComponentInjector();
        this.beanFactoryInjector = injectorFactory.createBeanFactoryInjector();
        this.testedComponentResolver = injectorFactory.createTestedComponentResolver();
        this.systemStreamInjector = injectorFactory.createSystemOutInjector();
    }

    public void beforeEach(ExtensionContext context) {
        List<Object> testInstances = TestObjects.getTestInstances(context);
        this.testedComponentResolver.verifyState(testInstances, BeforeEach.class);
        this.runtimeContextComponentInjector.injectIfFound(testInstances);
        this.repositoryInjector.injectIfFound(testInstances);
        this.restClientInjector.injectIfFound(testInstances);
        this.beanFactoryInjector.injectIfFound(testInstances);
        this.systemStreamInjector.injectIfFound(testInstances);
    }

    public void beforeTestExecution(ExtensionContext context) {
        List<Object> testInstances = TestObjects.getTestInstances(context);
        this.getBeforeTestInvoker().invokeIfFound(context, testInstances);
        if (this.testModel.isInstanceConfigsPresent()) {
            new Configs.Builder().withConfigs(StatelessComponentFactory.getConfigResolver().getInstanceConfigMap(this.testModel, testInstances, new Config[0])).build();
        }
        Object testedComponentInstance = this.testedComponentResolver.getTestedComponentInstance(testInstances);
        try {
            this.userCreatedComponentInjector.injectIfFound(testInstances, List.of(testedComponentInstance));
        }
        catch (InaccessibleObjectException ex) {
            TestExceptions.reThrowInaccessibleObjectException((InaccessibleObjectException)ex);
        }
    }

    public void afterEach(ExtensionContext context) {
        InstanceContainer.clearContainer();
        AbstractFactory.clearFactories();
        DefaultConfigValueBuilderReSetter.resetDefaultConfigValueStorage();
        this.resetConfigurationIfPossible();
        this.systemStreamInjector.resetIfNecessary();
    }

    public void afterAll(ExtensionContext context) {
        EventLoopGroupFactory.clearEventLoopGroupFactory();
    }

    static {
        UnNamedModuleFixers.componentTestsFix();
    }
}

