/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit.internal;

import io.rxmicro.test.junit.RxMicroComponentTest;
import io.rxmicro.test.junit.RxMicroIntegrationTest;
import io.rxmicro.test.junit.RxMicroRestBasedMicroServiceTest;
import io.rxmicro.test.junit.internal.RxMicroComponentTestExtension;
import io.rxmicro.test.junit.internal.RxMicroIntegrationTestExtension;
import io.rxmicro.test.junit.internal.RxMicroRestBasedMicroServiceTestExtension;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.RxMicroTestExtension;
import io.rxmicro.test.local.model.TestModel;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtendWith;

public final class JUnitRxMicroTestExtension
implements RxMicroTestExtension {
    public void validate(TestModel testModel, Set<Class<? extends Annotation>> supportedRxMicroTestAnnotations) {
        ExtendWith[] extendWiths;
        for (ExtendWith extendWith : extendWiths = (ExtendWith[])testModel.getTestClass().getAnnotationsByType(ExtendWith.class)) {
            for (Class extension : extendWith.value()) {
                String messageTemplate = "Use '@?' annotation instead of @?(?.class)!";
                if (extension == RxMicroComponentTestExtension.class) {
                    throw new InvalidTestConfigException("Use '@?' annotation instead of @?(?.class)!", new Object[]{RxMicroComponentTest.class.getName(), ExtendWith.class.getSimpleName(), RxMicroComponentTestExtension.class.getSimpleName()});
                }
                if (extension == RxMicroIntegrationTestExtension.class) {
                    throw new InvalidTestConfigException("Use '@?' annotation instead of @?(?.class)!", new Object[]{RxMicroIntegrationTest.class.getName(), ExtendWith.class.getSimpleName(), RxMicroIntegrationTestExtension.class.getSimpleName()});
                }
                if (extension != RxMicroRestBasedMicroServiceTestExtension.class) continue;
                throw new InvalidTestConfigException("Use '@?' annotation instead of @?(?.class)!", new Object[]{RxMicroRestBasedMicroServiceTest.class.getName(), ExtendWith.class.getSimpleName(), RxMicroRestBasedMicroServiceTestExtension.class.getSimpleName()});
            }
        }
    }

    public Set<Class<? extends Annotation>> supportedPerClassAnnotations() {
        return Set.of(RxMicroComponentTest.class, RxMicroIntegrationTest.class, RxMicroRestBasedMicroServiceTest.class);
    }
}

