/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit.internal;

import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.junit.BeforeIterationMethodSource;
import io.rxmicro.test.junit.BeforeThisTest;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.extension.ExtensionContext;

final class BeforeTestInvoker {
    private final Map<Method, AtomicInteger> methodInvocationCounter = new HashMap<Method, AtomicInteger>();

    BeforeTestInvoker() {
    }

    void throwErrorIfFound(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        BeforeIterationMethodSource beforeIterationMethodSource = method.getAnnotation(BeforeIterationMethodSource.class);
        if (beforeIterationMethodSource != null) {
            throw new InvalidTestConfigException("'@?' annotation is redundant for '?.?()' test method. Remove redundant annotation!", new Object[]{BeforeIterationMethodSource.class.getSimpleName(), method.getDeclaringClass().getSimpleName(), method.getName()});
        }
        BeforeThisTest beforeThisTest = method.getAnnotation(BeforeThisTest.class);
        if (beforeThisTest != null) {
            throw new InvalidTestConfigException("'@?' annotation is redundant for '?.?()' test method. Remove redundant annotation!", new Object[]{BeforeThisTest.class.getSimpleName(), method.getDeclaringClass().getSimpleName(), method.getName()});
        }
    }

    void invokeIfFound(ExtensionContext context, List<Object> testInstances) {
        Method method = context.getRequiredTestMethod();
        AtomicInteger counter = this.methodInvocationCounter.computeIfAbsent(method, m -> new AtomicInteger(0));
        int index = counter.getAndIncrement();
        BeforeIterationMethodSource beforeIterationMethodSource = method.getAnnotation(BeforeIterationMethodSource.class);
        if (beforeIterationMethodSource != null) {
            this.validateRedundantAnnotation(method);
            this.invokeBeforeMethod(testInstances, beforeIterationMethodSource.methods()[index]);
        } else {
            BeforeThisTest beforeThisTest = method.getAnnotation(BeforeThisTest.class);
            if (beforeThisTest != null) {
                this.invokeBeforeMethod(testInstances, beforeThisTest.method());
            }
        }
    }

    private void validateRedundantAnnotation(Method method) {
        if (method.isAnnotationPresent(BeforeThisTest.class)) {
            throw new InvalidTestConfigException("Redundant annotation: '@?'. Remove it", new Object[]{BeforeThisTest.class.getName()});
        }
    }

    private void invokeBeforeMethod(List<Object> testInstances, String methodName) {
        try {
            Reflections.invokeMethod(testInstances, (String)methodName, (Object[])new Object[0]);
        }
        catch (CheckedWrapperException ex) {
            if (ex.isCause(NoSuchMethodException.class)) {
                throw new InvalidTestConfigException(ex.getMessage());
            }
            throw ex;
        }
    }
}

