/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.junit;

import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Configs;
import io.rxmicro.test.GlobalTestConfig;
import io.rxmicro.test.SystemErr;
import io.rxmicro.test.SystemOut;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public class ExAssertions
extends Assertions {
    private static boolean configInit;

    public static void assertInstantEquals(Instant expected, Instant actual, String message) {
        ExAssertions.assertInstantEquals(expected, actual, ExAssertions.getDefaultInstantCompareDelta(), message);
    }

    public static void assertInstantEquals(Instant expected, Instant actual, Supplier<String> messageSupplier) {
        ExAssertions.assertInstantEquals(expected, actual, ExAssertions.getDefaultInstantCompareDelta(), messageSupplier);
    }

    public static void assertInstantEquals(Instant expected, Instant actual) {
        ExAssertions.assertInstantEquals(expected, actual, ExAssertions.getDefaultInstantCompareDelta(), (String)null);
    }

    public static void assertInstantEquals(Instant expected, Instant actual, Duration delta, String message) {
        if (ExAssertions.isNotEqual(expected, actual, delta)) {
            throw new AssertionFailedError(message, (Object)expected, (Object)actual);
        }
    }

    public static void assertInstantEquals(Instant expected, Instant actual, Duration delta, Supplier<String> messageSupplier) {
        if (ExAssertions.isNotEqual(expected, actual, delta)) {
            throw new AssertionFailedError(messageSupplier.get(), (Object)expected, (Object)actual);
        }
    }

    public static void assertInstantEquals(Instant expected, Instant actual, Duration delta) {
        ExAssertions.assertInstantEquals(expected, actual, delta, (String)null);
    }

    public static void assertSystemOutContains(SystemOut systemOut, String message) {
        ExAssertions.assertSystemOutContains(systemOut.asString(), message);
    }

    public static void assertSystemOutContains(String systemOut, String message) {
        ExAssertions.assertTrue((boolean)systemOut.contains(message), () -> Formats.format((String)"System out does not contain required message: '?'! Full out is:\n?", (Object[])new Object[]{message, systemOut}));
    }

    public static void assertSystemErrContains(SystemErr systemErr, String message) {
        ExAssertions.assertSystemErrContains(systemErr.asString(), message);
    }

    public static void assertSystemErrContains(String systemErr, String message) {
        ExAssertions.assertTrue((boolean)systemErr.contains(message), () -> Formats.format((String)"System err does not contain required message: '?'! Full out is:\n?", (Object[])new Object[]{message, systemErr}));
    }

    private static boolean isNotEqual(Instant expected, Instant actual, Duration delta) {
        if (delta.isNegative()) {
            throw new IllegalArgumentException("delta must be positive!");
        }
        Instant minExpected = expected.minusMillis(delta.toMillis());
        Instant maxExpected = expected.plusMillis(delta.toMillis());
        return actual.isBefore(minExpected) || actual.isAfter(maxExpected);
    }

    private static Duration getDefaultInstantCompareDelta() {
        if (!configInit) {
            new Configs.Builder().buildIfNotConfigured();
            configInit = true;
        }
        return ((GlobalTestConfig)Configs.getConfig(GlobalTestConfig.class)).getDefaultInstantCompareDelta();
    }

    protected ExAssertions() {
    }
}

