/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.runtime.local.provider;

import io.rxmicro.common.util.Requires;
import io.rxmicro.runtime.local.InstanceProvider;
import java.util.function.Consumer;

public class ProxyInstanceProvider<T>
implements InstanceProvider<T> {
    private final InstanceProvider<T> instanceProvider;
    private Consumer<T> afterConstructCallback;

    public ProxyInstanceProvider(InstanceProvider<T> instanceProvider, Consumer<T> afterConstructCallback) {
        this.instanceProvider = (InstanceProvider)Requires.require(instanceProvider);
        this.afterConstructCallback = (Consumer)Requires.require(afterConstructCallback);
    }

    @Override
    public Class<? extends T> getType() {
        return this.instanceProvider.getType();
    }

    @Override
    public T getInstance() {
        T instance = this.instanceProvider.getInstance();
        if (this.afterConstructCallback != null) {
            this.afterConstructCallback.accept(instance);
            this.afterConstructCallback = null;
        }
        return instance;
    }
}

