/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.runtime.local;

import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.runtime.AutoRelease;
import io.rxmicro.runtime.detail.InstanceQualifier;
import io.rxmicro.runtime.internal.RuntimeVersion;
import io.rxmicro.runtime.local.InstanceProvider;
import io.rxmicro.runtime.local.provider.NotUniqueInstanceProvider;
import io.rxmicro.runtime.local.provider.ProxyInstanceProvider;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public final class InstanceContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceContainer.class);
    private static final Map<InstanceQualifier<?>, InstanceProvider<?>> COMPONENT_MAP = new ConcurrentHashMap();
    private static final Set<AutoRelease> AUTO_RELEASES = new HashSet<AutoRelease>();

    public static void registerAutoRelease(AutoRelease autoRelease) {
        AUTO_RELEASES.add((AutoRelease)Requires.require((Object)autoRelease, (String)Formats.format((String)"autoRelease couldn't be null", (Object[])new Object[0]), (Supplier[])new Supplier[0]));
    }

    @SafeVarargs
    public static <T> InstanceProvider<T> registerSingleton(InstanceProvider<T> componentInstanceProvider, InstanceQualifier<? super T> ... instanceQualifiers) {
        return InstanceContainer.register(componentInstanceProvider, (instanceProvider, instanceQualifier) -> {
            COMPONENT_MAP.put((InstanceQualifier<?>)instanceQualifier, new NotUniqueInstanceProvider(instanceQualifier.getType()));
            LOGGER.debug("Instance qualifier: '?' is not unique for '?' component", instanceQualifier, (Object)instanceProvider.getType().getName());
        }, instanceQualifiers);
    }

    @SafeVarargs
    public static <T> void overrideSingleton(InstanceProvider<T> componentInstanceProvider, InstanceQualifier<? super T> ... instanceQualifiers) {
        InstanceContainer.register(componentInstanceProvider, (instanceProvider, instanceQualifier) -> COMPONENT_MAP.put((InstanceQualifier<?>)instanceQualifier, (InstanceProvider<?>)instanceProvider), instanceQualifiers);
    }

    @SafeVarargs
    private static <T> InstanceProvider<T> register(InstanceProvider<T> componentInstanceProvider, BiConsumer<InstanceProvider<T>, InstanceQualifier<? super T>> conflictResolver, InstanceQualifier<? super T> ... instanceQualifiers) {
        InstanceProvider<Object> instanceProvider = AutoRelease.class.isAssignableFrom(componentInstanceProvider.getType()) ? new ProxyInstanceProvider<Object>(componentInstanceProvider, instance -> InstanceContainer.registerAutoRelease((AutoRelease)instance)) : componentInstanceProvider;
        for (InstanceQualifier<? super T> instanceQualifier : instanceQualifiers) {
            if (COMPONENT_MAP.containsKey(instanceQualifier)) {
                conflictResolver.accept(instanceProvider, instanceQualifier);
                continue;
            }
            COMPONENT_MAP.put(instanceQualifier, instanceProvider);
        }
        return instanceProvider;
    }

    public static <T> Optional<T> getSingleton(InstanceQualifier<? super T> instanceQualifier) {
        return Optional.ofNullable(COMPONENT_MAP.get(instanceQualifier)).map(InstanceProvider::getInstance);
    }

    public static <T> T getSingleton(InstanceQualifier<? super T> instanceQualifier, InstanceProvider<T> componentInstanceProvider) {
        InstanceProvider<Object> instanceProvider = COMPONENT_MAP.get(instanceQualifier);
        if (instanceProvider == null) {
            instanceProvider = InstanceContainer.registerSingleton(componentInstanceProvider, instanceQualifier);
        }
        return (T)instanceProvider.getInstance();
    }

    public static <T> Set<T> getSingletonsByType(Class<T> interfaceType) {
        return (Set)COMPONENT_MAP.values().stream().filter(p -> interfaceType.isAssignableFrom(p.getType()) && p.getClass() != NotUniqueInstanceProvider.class).map(p -> p.getInstance()).collect(ExCollectors.toTreeSet(Comparator.comparing(o -> o.getClass().getName())));
    }

    public static void clearContainer() {
        COMPONENT_MAP.clear();
        InstanceContainer.closeAll();
    }

    private static void closeAll() {
        for (AutoRelease autoRelease : AUTO_RELEASES) {
            try {
                autoRelease.release();
            }
            catch (Throwable throwable) {
                LOGGER.error(throwable, "Error during close: ?", (Object)throwable.getMessage());
            }
        }
        AUTO_RELEASES.clear();
    }

    private InstanceContainer() {
    }

    static {
        RuntimeVersion.setRxMicroVersion();
        Runtime.getRuntime().addShutdownHook(new Thread(InstanceContainer::closeAll, Formats.format((String)"?-closeable-shutdown-hook", (Object[])new Object[]{"rx-micro"})));
    }
}

