/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.runtime.local;

import io.rxmicro.common.RxMicroException;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Formats;
import io.rxmicro.runtime.internal.RuntimeVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Implementations {
    public static <T> T getRequiredRuntimeImplementation(Class<T> serviceInterface, Function<Class<T>, ServiceLoader<T>> serviceLoader, RxMicroModule ... possibleImplementationModules) {
        return Implementations.getRequiredImplementation(serviceInterface, serviceLoader, "runtime module path", possibleImplementationModules);
    }

    public static <T> Optional<T> getOptionalImplementation(Class<T> serviceInterface, Function<Class<T>, ServiceLoader<T>> serviceLoader) {
        return Optional.ofNullable(Implementations.getImplementation(serviceInterface, serviceLoader));
    }

    public static <T> List<T> getAllImplementations(Class<T> serviceInterface, Function<Class<T>, ServiceLoader<T>> serviceLoader) {
        ServiceLoader<T> loader = serviceLoader.apply(serviceInterface);
        Iterator<T> iterator = loader.iterator();
        ArrayList<T> implementations = new ArrayList<T>();
        while (iterator.hasNext()) {
            implementations.add(iterator.next());
        }
        return implementations;
    }

    private static <T> T getRequiredImplementation(Class<T> serviceInterface, Function<Class<T>, ServiceLoader<T>> serviceLoader, String type, RxMicroModule ... possibleImplementationModules) {
        T implementation = Implementations.getImplementation(serviceInterface, serviceLoader);
        if (implementation == null) {
            if (possibleImplementationModules.length == 0) {
                throw new ImplementationLoadFailedException("Missing an implementation of '?' component! Add module with implementation to ?!", serviceInterface.getName(), type);
            }
            boolean single = possibleImplementationModules.length == 1;
            String messageTemplate = single ? "Missing an implementation of '?' component! Add '?' module to ?!" : "Missing an implementation of '?' component! Add one of the following ? modules to ?!";
            throw new ImplementationLoadFailedException(messageTemplate, serviceInterface.getName(), single ? possibleImplementationModules[0].getName() : Arrays.stream(possibleImplementationModules).map(m -> Formats.format((String)"'?'", (Object[])new Object[]{m.getName()})).collect(Collectors.joining(", ")), type);
        }
        return implementation;
    }

    private static <T> T getImplementation(Class<T> serviceInterface, Function<Class<T>, ServiceLoader<T>> serviceLoader) {
        List<T> implementations = Implementations.getAllImplementations(serviceInterface, serviceLoader);
        if (implementations.isEmpty()) {
            return null;
        }
        if (implementations.size() == 1) {
            return implementations.get(0);
        }
        throw new ImplementationLoadFailedException("Detected a few implementations of '?' component: ?! The RxMicro framework requires only one module from ? list per runtime! Remove redundant module(s) from module path!", serviceInterface.getName(), implementations.stream().map(i -> i.getClass().getName()).collect(Collectors.toList()), implementations.stream().map(i -> i.getClass().getModule().getName()).collect(Collectors.toList()));
    }

    private Implementations() {
    }

    static {
        RuntimeVersion.setRxMicroVersion();
    }

    public static final class ImplementationLoadFailedException
    extends RxMicroException {
        private ImplementationLoadFailedException(String message, Object ... args) {
            super(message, args);
        }
    }
}

