/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.runtime.local;

import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.util.Formats;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.runtime.detail.ByTypeInstanceQualifier;
import io.rxmicro.runtime.detail.InstanceQualifier;
import io.rxmicro.runtime.internal.RuntimeVersion;
import io.rxmicro.runtime.local.InstanceContainer;
import io.rxmicro.runtime.local.provider.EagerInstanceProvider;
import io.rxmicro.runtime.local.provider.LazyInstanceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class AbstractFactory {
    private static final Map<String, AbstractFactory> FACTORIES = new HashMap<String, AbstractFactory>();

    public static void clearFactories() {
        FACTORIES.clear();
    }

    protected static Supplier<InvalidStateException> implNotFoundError(InstanceQualifier<?> instanceQualifier) {
        return () -> {
            throw new InvalidStateException("Implementation not found: ?", new Object[]{instanceQualifier});
        };
    }

    protected static Supplier<InvalidStateException> implNotFoundError(Class<?> interfaceName) {
        return () -> {
            throw new InvalidStateException("Implementation not found: ?", new Object[]{interfaceName.getName()});
        };
    }

    protected static AbstractFactory get(String implClassName) {
        return FACTORIES.computeIfAbsent(implClassName, cl -> (AbstractFactory)Reflections.instantiate((String)Formats.format((String)"?.?", (Object[])new Object[]{"rxmicro", cl}), (Object[])new Object[0]));
    }

    protected static void registerFactory(String implClassName, AbstractFactory factory) {
        if (FACTORIES.put(implClassName, factory) != null) {
            throw new InvalidStateException("Factory already registered: implClassName=?", new Object[]{implClassName});
        }
    }

    public final <T> Optional<T> getImpl(InstanceQualifier<? super T> instanceQualifier) {
        return InstanceContainer.getSingleton(instanceQualifier);
    }

    protected final <T> void register(Class<T> interfaceType, Supplier<T> instanceSupplier) {
        this.register(interfaceType, instanceSupplier, new ByTypeInstanceQualifier<T>(interfaceType));
    }

    @SafeVarargs
    protected final <T> void register(Class<T> instanceType, Supplier<T> instanceSupplier, InstanceQualifier<? super T> ... instanceQualifiers) {
        InstanceContainer.registerSingleton(new LazyInstanceProvider<T>(instanceType, instanceSupplier), instanceQualifiers);
    }

    @SafeVarargs
    protected final <T> void register(T instance, InstanceQualifier<? super T> ... instanceQualifiers) {
        InstanceContainer.registerSingleton(new EagerInstanceProvider<T>(instance), instanceQualifiers);
    }

    @SafeVarargs
    protected final <T> void override(T instance, InstanceQualifier<? super T> ... instanceQualifiers) {
        InstanceContainer.overrideSingleton(new EagerInstanceProvider<T>(instance), instanceQualifiers);
    }

    static {
        RuntimeVersion.setRxMicroVersion();
    }
}

