/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.runtime.internal;

import io.rxmicro.common.local.StartTimeStampHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class RuntimeVersion {
    private static final String RX_MICRO_VERSION;
    private static final String RX_MICRO_VERSION_PROPERTY = "rxmicro.version";

    public static void setRxMicroVersion() {
    }

    public static String getRxMicroVersion() {
        return RX_MICRO_VERSION;
    }

    private static String resolveVersion() {
        Package pkg = RuntimeVersion.class.getPackage();
        String implVersion = pkg.getImplementationVersion();
        if (implVersion != null) {
            return implVersion;
        }
        return RuntimeVersion.tryReadPomProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String tryReadPomProperties() {
        String unresolved = "unresolved";
        try {
            Properties properties = new Properties();
            try (InputStream in = RuntimeVersion.class.getClassLoader().getResourceAsStream("META-INF/maven/io.rxmicro/rxmicro-runtime/pom.properties");){
                if (in != null) {
                    properties.load(in);
                    String string2 = properties.getProperty("version", "unresolved");
                    return string2;
                }
                String string = "unresolved";
                return string;
            }
        }
        catch (IOException ignore) {
            return "unresolved";
        }
    }

    private RuntimeVersion() {
    }

    static {
        StartTimeStampHelper.init();
        RX_MICRO_VERSION = RuntimeVersion.resolveVersion();
        System.setProperty(RX_MICRO_VERSION_PROPERTY, RX_MICRO_VERSION);
    }
}

