/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.runtime.detail;

import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.runtime.internal.RuntimeVersion;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class RuntimeReflections {
    private static final Map<Class<?>, Map<String, Field>> CACHE = new HashMap();

    public static void setFieldValue(Object model, String fieldName, Object value, Consumer<Field> setAccessibleConsumer) {
        Field field = RuntimeReflections.getCachedField(model, fieldName, setAccessibleConsumer);
        try {
            field.set(model, value);
        }
        catch (IllegalAccessException ex) {
            throw new CheckedWrapperException((Throwable)ex);
        }
    }

    public static Object getFieldValue(Object model, String fieldName, Consumer<Field> setAccessibleConsumer) {
        Field field = RuntimeReflections.getCachedField(model, fieldName, setAccessibleConsumer);
        try {
            return field.get(model);
        }
        catch (IllegalAccessException ex) {
            throw new CheckedWrapperException((Throwable)ex);
        }
    }

    public static Object invoke(Object model, String methodName, Consumer<Method> setAccessibleConsumer, Object ... args) {
        List<Class<?>> argTypes = Arrays.stream(args).map(Object::getClass).collect(Collectors.toList());
        Method method = RuntimeReflections.getMethod(model, methodName, argTypes, setAccessibleConsumer);
        try {
            return method.invoke(model, args);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new CheckedWrapperException((Throwable)ex);
        }
    }

    private static Field getCachedField(Object model, String fieldName, Consumer<Field> setAccessibleConsumer) {
        Class<?> cl = model.getClass();
        Map fieldMap = CACHE.computeIfAbsent(cl, c -> RuntimeReflections.createFieldMap(cl, setAccessibleConsumer));
        Field field = (Field)fieldMap.get(fieldName);
        if (field == null) {
            throw new InvalidStateException("Field '?.?' is not defined", new Object[]{cl.getName(), fieldName});
        }
        return field;
    }

    private static Method getMethod(Object model, String methodName, List<Class<?>> argTypes, Consumer<Method> setAccessibleConsumer) {
        Class<?> cl = model instanceof Class ? (Class<?>)model : model.getClass();
        try {
            Method method = cl.getDeclaredMethod(methodName, argTypes.toArray(new Class[0]));
            if (setAccessibleConsumer != null) {
                setAccessibleConsumer.accept(method);
            }
            return method;
        }
        catch (NoSuchMethodException ignore) {
            throw new InvalidStateException("Method '?.?(?)' is not defined", new Object[]{cl.getName(), methodName, argTypes.stream().map(Class::getName).collect(Collectors.joining(", "))});
        }
    }

    private static Map<String, Field> createFieldMap(Class<?> cl, Consumer<Field> setAccessibleConsumer) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Class<?> currentClass = cl; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                if (setAccessibleConsumer != null) {
                    setAccessibleConsumer.accept(field);
                }
                if (map.put(field.getName(), field) == null) continue;
                throw new InvalidStateException("Class '?' has duplicate field with name: '?'", new Object[]{cl.getName(), field.getName()});
            }
        }
        return map;
    }

    private RuntimeReflections() {
    }

    static {
        RuntimeVersion.setRxMicroVersion();
    }
}

