/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.model;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;

public final class UrlSegments {
    private final String urlTemplate;
    private final List<String> variables;

    public UrlSegments(String urlTemplate, List<String> variables) {
        this.urlTemplate = (String)Requires.require((Object)urlTemplate);
        this.variables = ExCollections.unmodifiableList(variables);
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public String getOriginalUrl() {
        return Formats.format((String)this.urlTemplate, (Object[])this.variables.stream().map(v -> Formats.format((String)"${?}", (Object[])new Object[]{v})).toArray());
    }

    public int hashCode() {
        return this.urlTemplate.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UrlSegments that = (UrlSegments)other;
        return this.urlTemplate.equals(that.urlTemplate);
    }

    public String toString() {
        return this.getOriginalUrl();
    }
}

