/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.model;

import io.rxmicro.common.util.Formats;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.HttpVersion;
import io.rxmicro.http.error.HttpErrorException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public abstract class HttpCallFailedException
extends HttpErrorException {
    private final HttpVersion version;
    private final HttpHeaders headers;
    private byte[] body;
    private String bodyAsString;

    protected HttpCallFailedException(int statusCode, HttpVersion version, HttpHeaders headers, byte[] body, String bodyAsString) {
        super(statusCode);
        this.version = version;
        this.headers = headers;
        this.body = body;
        this.bodyAsString = bodyAsString;
    }

    public final HttpVersion getVersion() {
        return this.version;
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final byte[] getBody() {
        if (this.body == null) {
            this.body = this.bodyAsString.getBytes(StandardCharsets.UTF_8);
        }
        return this.body;
    }

    public final String getBodyAsString() {
        if (this.bodyAsString == null) {
            this.bodyAsString = this.body.length > 0 ? new String(this.body, StandardCharsets.UTF_8) : "";
        }
        return this.bodyAsString;
    }

    public boolean isBodyPresent() {
        if (this.body != null) {
            return this.body.length != 0;
        }
        return !this.getBodyAsString().isEmpty();
    }

    public final String getMessage() {
        return Formats.format((String)"? ??????", (Object[])new Object[]{this.getStatusCode(), this.version.getText(), System.lineSeparator(), this.headers.getEntries().stream().map(e -> Formats.format((String)"?: ?", (Object[])new Object[]{e.getKey(), String.join((CharSequence)", ", (CharSequence)e.getValue())})).collect(Collectors.joining(System.lineSeparator())), System.lineSeparator(), System.lineSeparator(), this.getBodyAsString()});
    }
}

