/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.local;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Strings;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.local.AbstractValidatedConverter;
import io.rxmicro.rest.model.HttpModelType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class FromStringValueConverter
extends AbstractValidatedConverter {
    private static final int DEFAULT_SIZE = 5;
    private static final List EMPTY_LIST = List.of();

    protected String getStringArrayDelimiter() {
        return "|";
    }

    protected final <E extends Enum<E>> E toEnum(Class<E> enumClass, String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException ignore) {
            throw new ValidationException("Invalid ? \"?\": Expected a value from the set ?, but actual is '?'!", new Object[]{httpModelType, modelName, Arrays.toString(enumClass.getEnumConstants()), value});
        }
    }

    protected final <E extends Enum<E>> List<E> toEnumList(Class<E> enumClass, List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<E> result = new ArrayList<E>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List strings = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < strings.size(); ++j) {
                    result.add(this.toEnum(enumClass, (String)strings.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final <E extends Enum<E>> Set<E> toEnumSet(Class<E> enumClass, List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toEnumList(enumClass, list, httpModelType, modelName));
    }

    protected final Boolean toBoolean(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        if (Boolean.TRUE.toString().equals(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(value)) {
            return Boolean.FALSE;
        }
        throw new ValidationException("Invalid ? \"?\": Expected a boolean value ('true' or 'false'), but actual is '?'!", new Object[]{httpModelType, modelName, value});
    }

    protected final List<Boolean> toBooleanList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Boolean> result = new ArrayList<Boolean>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toBoolean((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Boolean> toBooleanSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toBooleanList(list, httpModelType, modelName));
    }

    protected final Byte toByte(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException ignore) {
            throw this.createExpectedIntegerValidationException(value, httpModelType, modelName, (byte)-128, (byte)127);
        }
    }

    protected final List<Byte> toByteList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Byte> result = new ArrayList<Byte>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toByte((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Byte> toByteSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toByteList(list, httpModelType, modelName));
    }

    protected final Short toShort(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException ignore) {
            throw this.createExpectedIntegerValidationException(value, httpModelType, modelName, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
    }

    protected final List<Short> toShortList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Short> result = new ArrayList<Short>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toShort((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Short> toShortSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toShortList(list, httpModelType, modelName));
    }

    protected final Integer toInteger(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            throw this.createExpectedIntegerValidationException(value, httpModelType, modelName, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    protected final List<Integer> toIntegerList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Integer> result = new ArrayList<Integer>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toInteger((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Integer> toIntegerSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toIntegerList(list, httpModelType, modelName));
    }

    protected final Long toLong(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ignore) {
            throw this.createExpectedIntegerValidationException(value, httpModelType, modelName, Long.MIN_VALUE, Long.MAX_VALUE);
        }
    }

    protected final List<Long> toLongList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Long> result = new ArrayList<Long>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toLong((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Long> toLongSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toLongList(list, httpModelType, modelName));
    }

    protected final BigInteger toBigInteger(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException ignore) {
            throw new ValidationException("Invalid ? \"?\": Expected an integer value, but actual is '?'!", new Object[]{httpModelType, modelName, value});
        }
    }

    protected final List<BigInteger> toBigIntegerList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<BigInteger> result = new ArrayList<BigInteger>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toBigInteger((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<BigInteger> toBigIntegerSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toBigIntegerList(list, httpModelType, modelName));
    }

    protected final Float toFloat(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(this.floatIfValid(value, Float.parseFloat(value), httpModelType, modelName));
        }
        catch (NumberFormatException ignore) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value, but actual is '?'!", new Object[]{httpModelType, modelName, value});
        }
    }

    protected final List<Float> toFloatList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Float> result = new ArrayList<Float>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toFloat((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Float> toFloatSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toFloatList(list, httpModelType, modelName));
    }

    protected final Double toDouble(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return this.doubleIfValid(value, Double.parseDouble(value), httpModelType, modelName);
        }
        catch (NumberFormatException ignore) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value, but actual is '?'!", new Object[]{httpModelType, modelName, value});
        }
    }

    protected final List<Double> toDoubleList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Double> result = new ArrayList<Double>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toDouble((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Double> toDoubleSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toDoubleList(list, httpModelType, modelName));
    }

    protected final BigDecimal toBigDecimal(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException ignore) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value, but actual is '?'!", new Object[]{httpModelType, modelName, value});
        }
    }

    protected final List<BigDecimal> toBigDecimalList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toBigDecimal((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<BigDecimal> toBigDecimalSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toBigDecimalList(list, httpModelType, modelName));
    }

    protected final Instant toInstant(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException ignore) {
            throw new ValidationException("Invalid ? \"?\": Expected an ISO-8601 instant (Example: '?'), but actual is '?'!", new Object[]{httpModelType, modelName, "1987-04-10T23:40:15.789Z", value});
        }
    }

    protected final List<Instant> toInstantList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Instant> result = new ArrayList<Instant>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toInstant((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Instant> toInstantSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toInstantList(list, httpModelType, modelName));
    }

    protected final Character toCharacter(String value, HttpModelType httpModelType, String modelName) {
        if (value == null) {
            return null;
        }
        if (value.length() != 1) {
            throw new ValidationException("Invalid ? \"?\": Expected a character, but actual is '?'!", new Object[]{httpModelType, modelName, value});
        }
        return Character.valueOf(value.charAt(0));
    }

    protected final List<Character> toCharacterList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<Character> result = new ArrayList<Character>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toCharacter((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<Character> toCharacterSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toCharacterList(list, httpModelType, modelName));
    }

    protected final String toString(String value, HttpModelType httpModelType, String modelName) {
        return value;
    }

    protected final List<String> toStringList(List<String> list, HttpModelType httpModelType, String modelName) {
        if (list != null) {
            int size = list.size();
            ArrayList<String> result = new ArrayList<String>(size == 1 ? 5 : size);
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                List array = Strings.split((String)value, (String)this.getStringArrayDelimiter());
                for (int j = 0; j < array.size(); ++j) {
                    result.add(this.toString((String)array.get(j), httpModelType, modelName));
                }
            }
            return Collections.unmodifiableList(result);
        }
        return EMPTY_LIST;
    }

    protected final Set<String> toStringSet(List<String> list, HttpModelType httpModelType, String modelName) {
        return ExCollections.unmodifiableOrderedSet(this.toStringList(list, httpModelType, modelName));
    }

    protected final void throwNotImplYet(String message) {
        throw new UnsupportedOperationException(message);
    }
}

