/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.local;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;

public abstract class AbstractValidatedConverter {
    protected final ValidationException createExpectedIntegerValidationException(String value, HttpModelType httpModelType, String modelName, Object minValue, Object maxValue) {
        int i;
        if (value.isEmpty()) {
            throw new ValidationException("Invalid ? \"?\": Expected an integer value, but actual is '?'!", new Object[]{httpModelType, modelName, value});
        }
        boolean isNegative = value.charAt(0) == '-';
        int n = i = isNegative || value.charAt(0) == '+' ? 1 : 0;
        while (i < value.length()) {
            if (!Character.isDigit(value.charAt(i))) {
                this.throwValidationExceptionIfValueContainsNotDigitsOnly(value, httpModelType, modelName, minValue, maxValue);
            }
            ++i;
        }
        String sign = isNegative ? ">=" : "<=";
        Object criticalValue = isNegative ? minValue : maxValue;
        throw new ValidationException("Invalid ? \"?\": Expected an integer value that ? '?', but actual is '?'!", new Object[]{httpModelType, modelName, sign, criticalValue, value});
    }

    private void throwValidationExceptionIfValueContainsNotDigitsOnly(String value, HttpModelType httpModelType, String modelName, Object minValue, Object maxValue) {
        if ("NaN".equals(value) || "+NaN".equals(value) || "-NaN".equals(value)) {
            throw new ValidationException("Invalid ? \"?\": Expected an integer value, but actual is 'NaN'!", new Object[]{httpModelType, modelName});
        }
        if ("Infinity".equals(value) || "+Infinity".equals(value)) {
            throw new ValidationException("Invalid ? \"?\": Expected an integer value that <= '?', but actual is '?'!", new Object[]{httpModelType, modelName, maxValue, value});
        }
        if ("-Infinity".equals(value)) {
            throw new ValidationException("Invalid ? \"?\": Expected an integer value that >= '?', but actual is '?'!", new Object[]{httpModelType, modelName, minValue, value});
        }
        throw new ValidationException("Invalid ? \"?\": Expected an integer value, but actual is '?'!", new Object[]{httpModelType, modelName, value});
    }

    protected final float floatIfValid(String value, float result, HttpModelType httpModelType, String modelName) {
        if (result == Float.POSITIVE_INFINITY) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value that <= '?', but actual is '?'!", new Object[]{httpModelType, modelName, Float.valueOf(Float.MAX_VALUE), value});
        }
        if (result == Float.NEGATIVE_INFINITY) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value that >= '-?', but actual is '?'!", new Object[]{httpModelType, modelName, Float.valueOf(Float.MAX_VALUE), value});
        }
        if (Float.isNaN(result)) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value, but actual is 'NaN'!", new Object[]{httpModelType, modelName});
        }
        return result;
    }

    protected final double doubleIfValid(String value, double result, HttpModelType httpModelType, String modelName) {
        if (result == Double.POSITIVE_INFINITY) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value that <= '?', but actual is '?'!", new Object[]{httpModelType, modelName, Double.MAX_VALUE, value});
        }
        if (result == Double.NEGATIVE_INFINITY) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value that >= '-?', but actual is '?'!", new Object[]{httpModelType, modelName, Double.MAX_VALUE, value});
        }
        if (Double.isNaN(result)) {
            throw new ValidationException("Invalid ? \"?\": Expected a decimal value, but actual is 'NaN'!", new Object[]{httpModelType, modelName});
        }
        return result;
    }
}

