/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.util;

import io.netty.channel.ChannelHandlerContext;
import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Secrets;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.netty.internal.model.HttpContentHolder;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;

public final class HttpFragmentBuilder {
    private final Secrets secrets = Secrets.getDefaultInstance();
    private final RestServerConfig restServerConfig;

    public HttpFragmentBuilder(RestServerConfig restServerConfig) {
        this.restServerConfig = restServerConfig;
    }

    public String buildRequestString(NettyHttpRequest request) {
        return Formats.format((String)"? ??", (Object[])new Object[]{request.getMethod(), request.getUri(), request.isQueryStringPresent() ? "?" + this.secrets.hideAllSecretsIn(request.getQueryString()) : ""});
    }

    public String buildRemoteClientSocket(ChannelHandlerContext ctx, NettyHttpRequest request) {
        if (this.restServerConfig.getForwardedHeaderNames().isEmpty()) {
            return ctx.channel().remoteAddress().toString();
        }
        String realIpAddresses = this.restServerConfig.getForwardedHeaderNames().stream().flatMap(h -> Optional.ofNullable(request.getHeaders().getValue(h)).stream().map(v -> Formats.format((String)"?: ?", (Object[])new Object[]{h, v}))).collect(Collectors.joining(";"));
        if (realIpAddresses.isEmpty()) {
            return ctx.channel().remoteAddress().toString();
        }
        return Formats.format((String)"? (?)", (Object[])new Object[]{ctx.channel().remoteAddress(), realIpAddresses});
    }

    public String buildHeaders(boolean isRequestIdGenerated, HttpHeaders headers) {
        return headers.getEntries().stream().filter(e -> isRequestIdGenerated && !"Request-Id".equals(e.getKey())).map(e -> Formats.format((String)"?: ?", (Object[])new Object[]{e.getKey(), this.secrets.hideIfSecret((String)e.getValue())})).collect(Collectors.joining(System.lineSeparator()));
    }

    public String buildBody(HttpContentHolder httpContentHolder) {
        return httpContentHolder.isFileContent() ? "<file content>" : (httpContentHolder.isContentPresent() ? this.secrets.hideAllSecretsIn(new String(httpContentHolder.getContent(), StandardCharsets.UTF_8)) : "");
    }
}

