/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.util;

import io.netty.channel.Channel;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.rest.server.RestServerConfig;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class HealthCheckTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckTools.class);

    public static boolean isHealthCheckToolAddress(RestServerConfig restServerConfig, Channel channel) {
        SocketAddress socketAddress = channel.remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            String address = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            return restServerConfig.getHealthCheckToolAddresses().contains(address);
        }
        LOGGER.warn("Remote socket address is not ?: ? (?), so it is impossible to verify that this address belongs to health check tool!", (Object)InetSocketAddress.class.getSimpleName(), (Object)socketAddress, socketAddress.getClass());
        return false;
    }

    private HealthCheckTools() {
    }
}

