/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.model;

import io.netty.handler.codec.http.HttpHeaders;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.http.local.AbstractHttpHeaders;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class NettyReadOnlyHttpHeaders
extends AbstractHttpHeaders {
    private final String requestId;
    private final boolean requestIdGenerated;
    private final HttpHeaders httpHeaders;

    NettyReadOnlyHttpHeaders(String requestId, boolean requestIdGenerated, HttpHeaders httpHeaders) {
        this.requestId = requestId;
        this.requestIdGenerated = requestIdGenerated;
        this.httpHeaders = httpHeaders;
    }

    public String getValue(String name) {
        if (this.requestIdGenerated && "Request-Id".equalsIgnoreCase(name)) {
            return this.requestId;
        }
        return this.httpHeaders.get(name);
    }

    public List<String> getValues(String name) {
        if (this.requestIdGenerated && "Request-Id".equalsIgnoreCase(name)) {
            return List.of(this.requestId);
        }
        return this.httpHeaders.getAll(name);
    }

    public boolean contains(String name) {
        if (this.requestIdGenerated && "Request-Id".equalsIgnoreCase(name)) {
            return true;
        }
        return this.httpHeaders.contains(name);
    }

    public List<Map.Entry<String, String>> getEntries() {
        if (this.requestIdGenerated) {
            return ExCollections.unmodifiableList((Collection)Stream.concat(this.httpHeaders.entries().stream(), Stream.of(Map.entry("Request-Id", this.requestId))).collect(Collectors.toList()));
        }
        return ExCollections.unmodifiableList((Collection)this.httpHeaders.entries());
    }

    public int size() {
        if (this.requestIdGenerated) {
            return this.httpHeaders.size() + 1;
        }
        return this.httpHeaders.size();
    }

    public boolean isNotEmpty() {
        return this.requestIdGenerated || !this.httpHeaders.isEmpty();
    }
}

