/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.model;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.local.RepeatableHttpHeaders;
import io.rxmicro.http.local.RepeatableValues;
import io.rxmicro.rest.server.detail.model.HttpResponse;
import io.rxmicro.rest.server.netty.internal.model.HttpContentHolder;
import io.rxmicro.rest.server.netty.internal.model.NettyWriteOnlyHttpHeaders;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public final class NettyHttpResponse
implements HttpResponse,
HttpContentHolder {
    private final NettyWriteOnlyHttpHeaders headers = new NettyWriteOnlyHttpHeaders();
    private HttpVersion httpVersion = HttpVersion.HTTP_1_1;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private byte[] content;
    private Path sendFilePath;

    public NettyHttpResponse() {
        this.setContent(EMPTY_CONTENT);
    }

    public FullHttpResponse toHttpResponseWithBody() {
        io.netty.handler.codec.http.HttpHeaders headers = this.headers.toHttpHeaders();
        return new DefaultFullHttpResponse(this.httpVersion, this.status, Unpooled.wrappedBuffer((byte[])this.content), headers, headers);
    }

    public io.netty.handler.codec.http.HttpResponse toHttpResponseWithoutBody() {
        io.netty.handler.codec.http.HttpHeaders headers = this.headers.toHttpHeaders();
        return new DefaultHttpResponse(this.httpVersion, this.status, headers);
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public NettyHttpResponse setStatus(int status) {
        this.status = HttpResponseStatus.valueOf((int)status);
        return this;
    }

    public NettyHttpResponse setVersion(io.rxmicro.http.HttpVersion httpVersion) {
        if (httpVersion == io.rxmicro.http.HttpVersion.HTTP_1_1) {
            this.httpVersion = HttpVersion.HTTP_1_1;
        } else if (httpVersion == io.rxmicro.http.HttpVersion.HTTP_1_0) {
            this.httpVersion = HttpVersion.HTTP_1_0;
        } else {
            throw new IllegalArgumentException("HTTP/2 is not supported now");
        }
        return this;
    }

    public NettyHttpResponse addHeader(String name, String value) {
        if (value != null) {
            this.headers.add(name, value);
        }
        return this;
    }

    public NettyHttpResponse setOrAddHeaders(HttpHeaders headers) {
        if (headers.isNotEmpty()) {
            if (headers instanceof RepeatableHttpHeaders) {
                this.headers.setOrAddAll((RepeatableValues)((RepeatableHttpHeaders)headers));
            } else {
                List all = headers.getEntries();
                for (int i = 0; i < all.size(); ++i) {
                    Map.Entry entry = (Map.Entry)all.get(i);
                    this.headers.setOrAdd((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        return this;
    }

    public NettyHttpResponse setHeader(String name, String value) {
        if (value != null) {
            this.headers.set(name, value);
        }
        return this;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public NettyWriteOnlyHttpHeaders getHeaders() {
        return this.headers;
    }

    public int getContentLength() {
        return this.content.length;
    }

    @Override
    public boolean isContentPresent() {
        return this.content.length > 0;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    public Path getSendFilePath() {
        return this.sendFilePath;
    }

    public NettyHttpResponse setContent(byte[] content) {
        if (this.sendFilePath != null) {
            throw new InvalidStateException("Can't set byte array content, because '?' send file path already set!", new Object[]{this.sendFilePath.toAbsolutePath()});
        }
        this.content = content;
        this.setHeader("Content-Length", content.length);
        return this;
    }

    public NettyHttpResponse sendFile(Path path) {
        if (this.content.length != 0) {
            throw new InvalidStateException("Can't send file, because byte content with ? bytes already set!", new Object[]{this.content.length});
        }
        this.sendFilePath = path;
        return this;
    }

    @Override
    public boolean isFileContent() {
        return this.sendFilePath != null;
    }
}

