/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.model;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.logger.RequestIdSupplier;
import io.rxmicro.rest.server.detail.model.HttpRequest;
import io.rxmicro.rest.server.feature.RequestIdGenerator;
import io.rxmicro.rest.server.netty.internal.model.HttpContentHolder;
import io.rxmicro.rest.server.netty.internal.model.NettyReadOnlyHttpHeaders;
import java.net.SocketAddress;
import java.util.Objects;

public final class NettyHttpRequest
implements HttpRequest,
RequestIdSupplier,
HttpContentHolder {
    public static final AttributeKey<String> REQUEST_ID_KEY = AttributeKey.valueOf((String)"Request-Id");
    public static final AttributeKey<Long> START_PROCESSING_REQUEST_TIME_KEY = AttributeKey.valueOf((String)"START_PROCESSING_REQUEST_TIME");
    private static final byte[] EMPTY = new byte[0];
    private final SocketAddress remoteAddress;
    private final String requestId;
    private final boolean requestIdGenerated;
    private final String uri;
    private final String queryString;
    private final FullHttpRequest fullHttpRequest;
    private HttpHeaders httpHeaders;
    private Boolean contentPresent;

    public NettyHttpRequest(RequestIdGenerator requestIdGenerator, FullHttpRequest fullHttpRequest, SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        String requestIdHeaderValue = fullHttpRequest.headers().get("Request-Id");
        if (requestIdHeaderValue != null) {
            this.requestId = requestIdHeaderValue;
            this.requestIdGenerated = false;
        } else {
            this.requestId = requestIdGenerator.getNextId();
            this.requestIdGenerated = true;
        }
        String uri = fullHttpRequest.uri();
        int index = uri.indexOf(63);
        if (index > 0) {
            this.uri = uri.substring(0, index);
            this.queryString = uri.substring(index + 1);
        } else {
            this.uri = uri;
            this.queryString = "";
        }
        this.fullHttpRequest = fullHttpRequest;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getMethod() {
        return this.fullHttpRequest.method().name();
    }

    public String getUri() {
        return this.uri;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public io.rxmicro.http.HttpVersion getVersion() {
        HttpVersion httpVersion = this.fullHttpRequest.protocolVersion();
        if (Objects.equals(HttpVersion.HTTP_1_1, httpVersion)) {
            return io.rxmicro.http.HttpVersion.HTTP_1_1;
        }
        if (Objects.equals(HttpVersion.HTTP_1_0, httpVersion)) {
            return io.rxmicro.http.HttpVersion.HTTP_1_0;
        }
        throw new InvalidStateException("Unsupported HTTP version: ?", new Object[]{httpVersion});
    }

    public HttpHeaders getHeaders() {
        if (this.httpHeaders == null) {
            this.httpHeaders = new NettyReadOnlyHttpHeaders(this.requestId, this.requestIdGenerated, this.fullHttpRequest.headers());
        }
        return this.httpHeaders;
    }

    @Override
    public boolean isContentPresent() {
        if (this.contentPresent == null) {
            this.contentPresent = this.fullHttpRequest.content().readableBytes() > 0;
        }
        return this.contentPresent;
    }

    @Override
    public byte[] getContent() {
        if (this.isContentPresent()) {
            return ByteBufUtil.getBytes((ByteBuf)this.fullHttpRequest.content());
        }
        return EMPTY;
    }

    @Override
    public boolean isFileContent() {
        return false;
    }

    public FullHttpRequest getFullHttpRequest() {
        return this.fullHttpRequest;
    }

    public boolean isRequestIdGenerated() {
        return this.requestIdGenerated;
    }
}

