/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.model;

import io.netty.handler.codec.http.HttpHeaders;
import java.time.Instant;
import java.util.Optional;

public abstract class AbstractReadableHttpHeaders
extends HttpHeaders {
    public Integer getInt(CharSequence name) {
        return Optional.ofNullable(this.get(name.toString())).map(Integer::parseInt).orElse(null);
    }

    public int getInt(CharSequence name, int defaultValue) {
        return Optional.ofNullable(this.get(name.toString())).map(Integer::parseInt).orElse(defaultValue);
    }

    public Short getShort(CharSequence name) {
        return Optional.ofNullable(this.get(name.toString())).map(Short::parseShort).orElse(null);
    }

    public short getShort(CharSequence name, short defaultValue) {
        return Optional.ofNullable(this.get(name.toString())).map(Short::parseShort).orElse(defaultValue);
    }

    public Long getTimeMillis(CharSequence name) {
        return Optional.ofNullable(this.get(name.toString())).map(v -> Instant.parse(v).toEpochMilli()).orElse(null);
    }

    public long getTimeMillis(CharSequence name, long defaultValue) {
        return Optional.ofNullable(this.get(name.toString())).map(v -> Instant.parse(v).toEpochMilli()).orElse(defaultValue);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public HttpHeaders add(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders add(String name, Iterable<?> values) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders set(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders set(String name, Iterable<?> values) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders setInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders remove(String name) {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders clear() {
        throw new UnsupportedOperationException();
    }
}

