/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component.writer;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.ImpossibleException;
import io.rxmicro.config.Configs;
import io.rxmicro.http.ProtocolSchema;
import io.rxmicro.logger.Logger;
import io.rxmicro.resource.PropertiesResources;
import io.rxmicro.rest.server.HttpServerConfig;
import io.rxmicro.rest.server.netty.internal.component.NettyErrorHandler;
import io.rxmicro.rest.server.netty.internal.component.writer.BaseNettyResponseWriter;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpRequest;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpResponse;
import io.rxmicro.rest.server.netty.internal.util.IOUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class NettySendFileResponseWriter
extends BaseNettyResponseWriter {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final Map<String, String> MIME_TYPES = (Map)PropertiesResources.loadProperties((String)"mime-types.properties").orElseThrow(() -> {
        throw new ImpossibleException("'mime-types.properties' classpath resource must be present!", new Object[0]);
    });
    private static final String UNKNOWN_MIME_TYPE = "application/octet-stream";
    private final boolean isSslHandlerPresent;
    private final Duration fileContentCacheDuration;

    public NettySendFileResponseWriter(Logger logger, NettyErrorHandler nettyErrorHandler) {
        super(logger, nettyErrorHandler);
        HttpServerConfig httpServerConfig = (HttpServerConfig)Configs.getConfig(HttpServerConfig.class);
        this.isSslHandlerPresent = httpServerConfig.getSchema() == ProtocolSchema.HTTPS;
        this.fileContentCacheDuration = httpServerConfig.getFileContentCacheDuration();
    }

    public void writeResponse(ChannelHandlerContext ctx, NettyHttpRequest request, NettyHttpResponse response) {
        boolean keepAlive = this.isKeepAlive(request);
        this.setCommonHeaders(request, response, keepAlive);
        Path sendFilePath = response.getSendFilePath();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(sendFilePath.toFile(), "r");
            long fileLength = randomAccessFile.length();
            response.setHeader("Content-Length", fileLength);
            response.setHeader("Content-Type", MIME_TYPES.getOrDefault(this.getPathExtension(sendFilePath), UNKNOWN_MIME_TYPE));
            this.setCacheHeaders(response, sendFilePath);
            ctx.write((Object)response.toHttpResponseWithoutBody());
            this.writeHttpResponseBody(ctx, request, response, keepAlive, randomAccessFile, fileLength);
        }
        catch (IOException exception) {
            IOUtils.closeQuietly(randomAccessFile);
            throw new CheckedWrapperException((Throwable)exception);
        }
    }

    private String getPathExtension(Path sendFilePath) {
        String name = String.valueOf(sendFilePath.getFileName());
        int index = name.lastIndexOf(46);
        return index != -1 ? name.substring(index + 1) : name;
    }

    private void setCacheHeaders(NettyHttpResponse response, Path sendFilePath) throws IOException {
        response.setHeader("Expires", DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.now().plus(this.fileContentCacheDuration).atOffset(ZoneOffset.UTC)));
        response.setHeader("Cache-Control", "private, max-age=" + this.fileContentCacheDuration.toSeconds());
        response.setHeader("Last-Modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(Files.getLastModifiedTime(sendFilePath, new LinkOption[0]).toInstant().atOffset(ZoneOffset.UTC)));
    }

    private void writeHttpResponseBody(ChannelHandlerContext ctx, NettyHttpRequest request, NettyHttpResponse response, boolean keepAlive, RandomAccessFile randomAccessFile, long fileLength) throws IOException {
        if (this.isSslHandlerPresent) {
            ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(randomAccessFile, 0L, fileLength, 8192))).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                IOUtils.closeQuietly(randomAccessFile);
                this.afterResponseWritten(ctx, (ChannelFuture)future, request, response, keepAlive);
            }));
        } else {
            ctx.write((Object)new DefaultFileRegion(randomAccessFile.getChannel(), 0L, fileLength), ctx.voidPromise());
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                IOUtils.closeQuietly(randomAccessFile);
                this.afterResponseWritten(ctx, (ChannelFuture)future, request, response, keepAlive);
            }));
        }
    }
}

