/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component.writer;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Configs;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.HttpVersion;
import io.rxmicro.http.local.PredefinedUrls;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.RequestIdSupplier;
import io.rxmicro.netty.runtime.NettyRuntimeConfig;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.netty.internal.component.NettyErrorHandler;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpRequest;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpResponse;
import io.rxmicro.rest.server.netty.internal.util.HealthCheckTools;
import io.rxmicro.rest.server.netty.internal.util.HttpFragmentBuilder;
import java.time.Duration;
import java.util.Optional;

class BaseNettyResponseWriter {
    final Logger logger;
    final NettyErrorHandler nettyErrorHandler;
    final NettyRuntimeConfig nettyRuntimeConfig;
    final RestServerConfig restServerConfig;
    final HttpFragmentBuilder httpFragmentBuilder;

    BaseNettyResponseWriter(Logger logger, NettyErrorHandler nettyErrorHandler) {
        this.logger = logger;
        this.nettyErrorHandler = nettyErrorHandler;
        this.nettyRuntimeConfig = (NettyRuntimeConfig)Configs.getConfig(NettyRuntimeConfig.class);
        this.restServerConfig = (RestServerConfig)Configs.getConfig(RestServerConfig.class);
        this.httpFragmentBuilder = new HttpFragmentBuilder(this.restServerConfig);
    }

    final boolean isKeepAlive(NettyHttpRequest httpRequest) {
        String value = httpRequest.getFullHttpRequest().headers().getAsString((CharSequence)"Connection");
        return !"close".equalsIgnoreCase(value);
    }

    final void setCommonHeaders(NettyHttpRequest request, NettyHttpResponse response, boolean keepAlive) {
        if (request.isRequestIdGenerated()) {
            if (this.restServerConfig.isReturnGeneratedRequestId()) {
                response.setHeader("Request-Id", request.getRequestId());
            }
        } else {
            response.setHeader("Request-Id", request.getRequestId());
        }
        if (keepAlive) {
            if (request.getVersion() == HttpVersion.HTTP_1_0) {
                response.setHeader("Connection", HttpHeaderValues.KEEP_ALIVE);
            }
        } else {
            response.setHeader("Connection", HttpHeaderValues.CLOSE);
        }
    }

    final void afterResponseWritten(ChannelHandlerContext ctx, ChannelFuture future, NettyHttpRequest request, NettyHttpResponse response, boolean keepAlive) {
        if (future.isSuccess()) {
            this.logResponse(ctx, request, response);
            if (!keepAlive) {
                future.channel().close();
            }
        } else {
            String requestId = (String)ctx.channel().attr(NettyHttpRequest.REQUEST_ID_KEY).get();
            this.nettyErrorHandler.logInternalError(ctx, requestId, future.cause());
            future.channel().close();
        }
    }

    private void logResponse(ChannelHandlerContext ctx, NettyHttpRequest request, NettyHttpResponse response) {
        if (this.logger.isTraceEnabled()) {
            if (HealthCheckTools.isHealthCheckToolAddress(this.restServerConfig, ctx.channel()) || this.restServerConfig.isDisableLoggerMessagesForHttpHealthChecks() && PredefinedUrls.HEALTH_CHECK_URLS.contains(request.getUri())) {
                return;
            }
            this.traceResponse(ctx, request, response);
        } else if (this.logger.isDebugEnabled()) {
            if (HealthCheckTools.isHealthCheckToolAddress(this.restServerConfig, ctx.channel()) || this.restServerConfig.isDisableLoggerMessagesForHttpHealthChecks() && PredefinedUrls.HEALTH_CHECK_URLS.contains(request.getUri())) {
                return;
            }
            this.debugResponse(ctx, request, response);
        }
    }

    private void traceResponse(ChannelHandlerContext ctx, NettyHttpRequest request, NettyHttpResponse response) {
        Long startTime = (Long)ctx.channel().attr(NettyHttpRequest.START_PROCESSING_REQUEST_TIME_KEY).get();
        this.logger.trace((RequestIdSupplier)request, "HTTP response: (Channel=?, Socket=?, Duration=?):\n? ?\n?\n\n?", new Object[]{this.nettyRuntimeConfig.getChannelIdType().getId(ctx.channel().id()), this.httpFragmentBuilder.buildRemoteClientSocket(ctx, request), startTime == null ? "undefined" : Formats.format((Duration)Duration.ofNanos(System.nanoTime() - startTime)), response.getHttpVersion(), response.getStatus(), this.httpFragmentBuilder.buildHeaders(false, (HttpHeaders)response.getHeaders()), this.httpFragmentBuilder.buildBody(response)});
    }

    private void debugResponse(ChannelHandlerContext ctx, NettyHttpRequest request, NettyHttpResponse response) {
        Long startTime = (Long)ctx.channel().attr(NettyHttpRequest.START_PROCESSING_REQUEST_TIME_KEY).get();
        this.logger.debug((RequestIdSupplier)request, "HTTP response: Channel=?, Socket=?, Body=? bytes, ContentType=?, Duration=?", (Object)this.nettyRuntimeConfig.getChannelIdType().getId(ctx.channel().id()), (Object)this.httpFragmentBuilder.buildRemoteClientSocket(ctx, request), (Object)Optional.ofNullable(response.getHeaders().getValue("Content-Length")).orElse("0"), (Object)Optional.ofNullable(response.getHeaders().getValue("Content-Type")).orElse("undefined"), (Object)(startTime == null ? "undefined" : Formats.format((Duration)Duration.ofNanos(System.nanoTime() - startTime))));
    }
}

