/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component.reader;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.rxmicro.config.Configs;
import io.rxmicro.http.local.PredefinedUrls;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.RequestIdSupplier;
import io.rxmicro.netty.runtime.NettyRuntimeConfig;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.feature.RequestIdGenerator;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpRequest;
import io.rxmicro.rest.server.netty.internal.util.HealthCheckTools;
import io.rxmicro.rest.server.netty.internal.util.HttpFragmentBuilder;
import java.util.Optional;

public final class NettyByteArrayRequestReader {
    private final Logger logger;
    private final NettyRuntimeConfig nettyRuntimeConfig;
    private final RestServerConfig restServerConfig;
    private final RequestIdGenerator requestIdGenerator;
    private final HttpFragmentBuilder httpFragmentBuilder;

    public NettyByteArrayRequestReader(Logger logger) {
        this.logger = logger;
        this.nettyRuntimeConfig = (NettyRuntimeConfig)Configs.getConfig(NettyRuntimeConfig.class);
        this.restServerConfig = (RestServerConfig)Configs.getConfig(RestServerConfig.class);
        this.requestIdGenerator = this.restServerConfig.getRequestIdGenerator();
        this.httpFragmentBuilder = new HttpFragmentBuilder(this.restServerConfig);
    }

    public NettyHttpRequest read(ChannelHandlerContext ctx, FullHttpRequest msg) {
        NettyHttpRequest request = new NettyHttpRequest(this.requestIdGenerator, msg, ctx.channel().remoteAddress());
        ctx.channel().attr(NettyHttpRequest.REQUEST_ID_KEY).set((Object)request.getRequestId());
        this.logRequest(ctx, request);
        return request;
    }

    private void logRequest(ChannelHandlerContext ctx, NettyHttpRequest request) {
        if (this.logger.isTraceEnabled()) {
            if (HealthCheckTools.isHealthCheckToolAddress(this.restServerConfig, ctx.channel()) || this.restServerConfig.isDisableLoggerMessagesForHttpHealthChecks() && PredefinedUrls.HEALTH_CHECK_URLS.contains(request.getUri())) {
                return;
            }
            this.traceRequest(ctx, request);
        } else if (this.logger.isDebugEnabled()) {
            if (HealthCheckTools.isHealthCheckToolAddress(this.restServerConfig, ctx.channel()) || this.restServerConfig.isDisableLoggerMessagesForHttpHealthChecks() && PredefinedUrls.HEALTH_CHECK_URLS.contains(request.getUri())) {
                return;
            }
            this.debugRequest(ctx, request);
        }
    }

    private void traceRequest(ChannelHandlerContext ctx, NettyHttpRequest request) {
        this.logger.trace((RequestIdSupplier)request, "HTTP request: (Channel=?, Socket=?):\n? ?\n?\n\n?", new Object[]{this.nettyRuntimeConfig.getChannelIdType().getId(ctx.channel().id()), this.httpFragmentBuilder.buildRemoteClientSocket(ctx, request), this.httpFragmentBuilder.buildRequestString(request), request.getVersion().getText(), this.httpFragmentBuilder.buildHeaders(request.isRequestIdGenerated(), request.getHeaders()), this.httpFragmentBuilder.buildBody(request)});
    }

    private void debugRequest(ChannelHandlerContext ctx, NettyHttpRequest request) {
        String remoteClientSocket = this.httpFragmentBuilder.buildRemoteClientSocket(ctx, request);
        String requestString = this.httpFragmentBuilder.buildRequestString(request);
        if (request.isContentPresent()) {
            this.logger.debug((RequestIdSupplier)request, "HTTP request:  Channel=?, Socket=?, Request=?, Body=? bytes, ContentType=?", (Object)this.nettyRuntimeConfig.getChannelIdType().getId(ctx.channel().id()), (Object)remoteClientSocket, (Object)requestString, (Object)Optional.ofNullable(request.getHeaders().getValue("Content-Length")).orElse("0"), (Object)Optional.ofNullable(request.getHeaders().getValue("Content-Type")).orElse("undefined"));
        } else {
            this.logger.debug((RequestIdSupplier)request, "HTTP request:  Channel=?, Socket=?, Request=?", (Object)this.nettyRuntimeConfig.getChannelIdType().getId(ctx.channel().id()), (Object)remoteClientSocket, (Object)requestString);
        }
    }
}

