/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.rxmicro.common.util.Requires;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.rest.server.detail.component.HttpResponseBuilder;
import io.rxmicro.rest.server.detail.model.HttpRequest;
import io.rxmicro.rest.server.local.component.HttpErrorResponseBodyBuilder;
import io.rxmicro.rest.server.local.component.RequestHandler;
import io.rxmicro.rest.server.netty.internal.component.NettyErrorHandler;
import io.rxmicro.rest.server.netty.internal.component.reader.NettyByteArrayRequestReader;
import io.rxmicro.rest.server.netty.internal.component.writer.NettyByteArrayResponseWriter;
import io.rxmicro.rest.server.netty.internal.component.writer.NettySendFileResponseWriter;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpRequest;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpResponse;

@ChannelHandler.Sharable
final class SharableNettyRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharableNettyRequestHandler.class);
    private final RequestHandler requestHandler;
    private final NettyByteArrayRequestReader nettyByteArrayRequestReader;
    private final NettyByteArrayResponseWriter nettyByteArrayResponseWriter;
    private final NettySendFileResponseWriter nettySendFileResponseWriter;
    private final NettyErrorHandler nettyErrorHandler;

    SharableNettyRequestHandler(RequestHandler requestHandler, HttpResponseBuilder responseBuilder, HttpErrorResponseBodyBuilder responseContentBuilder) {
        this.requestHandler = (RequestHandler)Requires.require((Object)requestHandler);
        this.nettyErrorHandler = new NettyErrorHandler(responseBuilder, responseContentBuilder);
        this.nettyByteArrayRequestReader = new NettyByteArrayRequestReader(LOGGER);
        this.nettyByteArrayResponseWriter = new NettyByteArrayResponseWriter(LOGGER, this.nettyErrorHandler);
        this.nettySendFileResponseWriter = new NettySendFileResponseWriter(LOGGER, this.nettyErrorHandler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        ctx.channel().attr(NettyHttpRequest.START_PROCESSING_REQUEST_TIME_KEY).set((Object)System.nanoTime());
        NettyHttpRequest request = this.nettyByteArrayRequestReader.read(ctx, msg);
        try {
            this.requestHandler.handle((HttpRequest)request).thenAccept(response -> {
                NettyHttpResponse nettyHttpResponse = (NettyHttpResponse)response;
                if (nettyHttpResponse.isFileContent()) {
                    this.nettySendFileResponseWriter.writeResponse(ctx, request, nettyHttpResponse);
                } else {
                    this.nettyByteArrayResponseWriter.writeResponse(ctx, request, nettyHttpResponse);
                }
            }).exceptionally(th -> this.handleError(ctx, request, (Throwable)th));
        }
        catch (Throwable th2) {
            this.handleError(ctx, request, th2);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String requestId = (String)ctx.channel().attr(NettyHttpRequest.REQUEST_ID_KEY).get();
        this.nettyErrorHandler.logInternalError(ctx, requestId, cause);
        ctx.close();
    }

    private Void handleError(ChannelHandlerContext ctx, NettyHttpRequest request, Throwable cause) {
        String requestId = (String)ctx.channel().attr(NettyHttpRequest.REQUEST_ID_KEY).get();
        NettyHttpResponse response = this.nettyErrorHandler.build(ctx, requestId, cause);
        this.nettyByteArrayResponseWriter.writeResponse(ctx, request, response);
        return null;
    }
}

