/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.netty.runtime.local.EventLoopGroupFactory;
import io.rxmicro.rest.server.ServerInstance;
import io.rxmicro.rest.server.detail.component.HttpResponseBuilder;
import io.rxmicro.rest.server.local.component.DefaultHttpErrorResponseBodyBuilder;
import io.rxmicro.rest.server.local.component.HttpErrorResponseBodyBuilder;
import io.rxmicro.rest.server.local.component.RequestHandler;
import io.rxmicro.rest.server.local.component.ServerFactory;
import io.rxmicro.rest.server.netty.internal.component.NettyHttpResponseBuilder;
import io.rxmicro.rest.server.netty.internal.component.NettyServer;
import io.rxmicro.rest.server.netty.internal.component.SharableNettyRequestHandler;
import io.rxmicro.runtime.local.Implementations;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;

public final class NettyServerFactory
implements ServerFactory {
    private static final Logger LOGGER;
    private final HttpResponseBuilder responseBuilder = new NettyHttpResponseBuilder();
    private final HttpErrorResponseBodyBuilder responseContentBuilder = Implementations.getOptionalImplementation(HttpErrorResponseBodyBuilder.class, ServiceLoader::load).orElseGet(DefaultHttpErrorResponseBodyBuilder::new);

    public ServerInstance startNewServer(RequestHandler requestHandler) {
        SharableNettyRequestHandler sharableNettyRequestHandler = new SharableNettyRequestHandler(requestHandler, this.responseBuilder, this.responseContentBuilder);
        return this.start(sharableNettyRequestHandler);
    }

    private ServerInstance start(SharableNettyRequestHandler sharableNettyRequestHandler) {
        CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread((Runnable)new NettyServer(sharableNettyRequestHandler, latch), Formats.format((String)"?-netty-server-controller", (Object[])new Object[]{"rx-micro"}));
        thread.setPriority(1);
        thread.start();
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            LOGGER.error((Throwable)ex, "Waiting for started failed");
        }
        return new ServerInstanceImpl(thread);
    }

    static {
        EventLoopGroupFactory.init();
        LOGGER = LoggerFactory.getLogger(NettyServerFactory.class);
    }

    private static final class ServerInstanceImpl
    implements ServerInstance {
        private final Thread thread;

        private ServerInstanceImpl(Thread thread) {
            this.thread = (Thread)Requires.require((Object)thread);
        }

        public void shutdown() {
            this.thread.interrupt();
        }

        public void shutdownAndWait() throws InterruptedException {
            this.shutdown();
            this.thread.join();
        }
    }
}

