/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.rxmicro.common.local.StartTimeStampHelper;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Configs;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.netty.runtime.local.EventLoopGroupFactory;
import io.rxmicro.rest.server.HttpServerConfig;
import io.rxmicro.rest.server.netty.internal.component.NettyClientConnectionController;
import io.rxmicro.rest.server.netty.internal.component.NettyConfiguratorController;
import io.rxmicro.rest.server.netty.internal.component.SharableNettyRequestHandler;
import java.util.concurrent.CountDownLatch;

final class NettyServer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private static final String DEFAULT_WORKER_THREAD_QUALIFIER = "http-server";
    private final HttpServerConfig httpServerConfig = (HttpServerConfig)Configs.getConfig(HttpServerConfig.class);
    private final SharableNettyRequestHandler sharableNettyRequestHandler;
    private final Class<? extends ServerSocketChannel> serverSocketChannelClass;
    private final EventLoopGroup acceptorGroup;
    private final EventLoopGroup workerGroup;
    private final String currentNettyTransport;
    private final CountDownLatch latch;

    NettyServer(SharableNettyRequestHandler sharableNettyRequestHandler, CountDownLatch latch) {
        this.sharableNettyRequestHandler = (SharableNettyRequestHandler)((Object)Requires.require((Object)((Object)sharableNettyRequestHandler)));
        EventLoopGroupFactory eventLoopGroupFactory = EventLoopGroupFactory.getEventLoopGroupFactory();
        this.currentNettyTransport = eventLoopGroupFactory.getCurrentNettyTransport();
        this.serverSocketChannelClass = eventLoopGroupFactory.getServerSocketChannelClass();
        this.acceptorGroup = eventLoopGroupFactory.getRequiredAcceptorEventLoopGroup();
        this.workerGroup = eventLoopGroupFactory.getRequiredWorkerEventLoopGroup(DEFAULT_WORKER_THREAD_QUALIFIER);
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.acceptorGroup, this.workerGroup).channel(this.serverSocketChannelClass)).childHandler((ChannelHandler)new NettyClientConnectionController(this.sharableNettyRequestHandler));
            NettyConfiguratorController.NettyConfigurator nettyConfigurator = NettyConfiguratorController.getNettyConfiguratorController().getNettyConfigurator();
            nettyConfigurator.getServerOptions().forEach((o, v) -> bootstrap.option(o, v));
            nettyConfigurator.getClientOptions().forEach((o, v) -> bootstrap.childOption(o, v));
            ChannelFuture channelFuture = bootstrap.bind(this.httpServerConfig.getHost(), this.httpServerConfig.getPort()).sync();
            this.logStartedMessage();
            this.latch.countDown();
            channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException ignore) {
            LOGGER.info("Retrieved shutdown request ...");
        }
        finally {
            Future workerGroupStopFuture = this.workerGroup.shutdownGracefully();
            Future serverGroupStopFuture = this.acceptorGroup.shutdownGracefully().addListener(f -> LOGGER.info("Server stopped"));
            workerGroupStopFuture.awaitUninterruptibly();
            serverGroupStopFuture.awaitUninterruptibly();
        }
    }

    private void logStartedMessage() {
        if (this.httpServerConfig.isStartTimeTrackerEnabled()) {
            LOGGER.info("Server started at ?:? using ? transport in ? millis.", () -> ((HttpServerConfig)this.httpServerConfig).getHost(), () -> ((HttpServerConfig)this.httpServerConfig).getPort(), () -> this.currentNettyTransport, () -> (System.nanoTime() - StartTimeStampHelper.START_TIME_STAMP) / 1000000L);
        } else {
            LOGGER.info("Server started at ?:? using ? transport.", () -> ((HttpServerConfig)this.httpServerConfig).getHost(), () -> ((HttpServerConfig)this.httpServerConfig).getPort(), () -> this.currentNettyTransport);
        }
    }
}

