/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.rxmicro.config.Configs;
import io.rxmicro.netty.runtime.NettyRuntimeConfig;
import io.rxmicro.rest.server.detail.component.HttpResponseBuilder;
import io.rxmicro.rest.server.feature.ErrorHandler;
import io.rxmicro.rest.server.local.component.HttpErrorResponseBodyBuilder;
import io.rxmicro.rest.server.netty.internal.model.NettyHttpResponse;

public final class NettyErrorHandler
extends ErrorHandler {
    private final HttpResponseBuilder responseBuilder;
    private final HttpErrorResponseBodyBuilder responseContentBuilder;
    private final NettyRuntimeConfig nettyRuntimeConfig;

    NettyErrorHandler(HttpResponseBuilder responseBuilder, HttpErrorResponseBodyBuilder responseContentBuilder) {
        this.responseBuilder = responseBuilder;
        this.responseContentBuilder = responseContentBuilder;
        this.nettyRuntimeConfig = (NettyRuntimeConfig)Configs.getConfig(NettyRuntimeConfig.class);
    }

    public NettyHttpResponse build(ChannelHandlerContext ctx, String requestId, Throwable cause) {
        this.logInternalError(ctx, requestId, "Request handling failed: message=?, Channel=?, IP=?", cause);
        return (NettyHttpResponse)this.responseContentBuilder.build(this.responseBuilder, HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "Internal error");
    }

    public void logInternalError(ChannelHandlerContext ctx, String requestId, Throwable cause) {
        this.logInternalError(ctx, requestId, "Netty channel error: message=?, Channel=?, IP=?", cause);
    }

    private void logInternalError(ChannelHandlerContext ctx, String requestId, String messageTemplate, Throwable cause) {
        LOGGER.error(() -> requestId, cause, messageTemplate, (Object)cause.getMessage(), (Object)this.nettyRuntimeConfig.getChannelIdType().getId(ctx.channel().id()), (Object)ctx.channel().remoteAddress());
    }
}

