/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.rxmicro.rest.server.netty.NettyConfiguratorBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class NettyConfiguratorController {
    private static final NettyConfiguratorController INSTANCE = new NettyConfiguratorController();
    private NettyConfigurator nettyConfigurator;
    private NettyConfiguratorBuilder nettyConfiguratorBuilder;

    public static NettyConfiguratorController getNettyConfiguratorController() {
        return INSTANCE;
    }

    public NettyConfigurator getNettyConfigurator() {
        if (this.nettyConfigurator == null) {
            this.nettyConfigurator = new NettyConfigurator(this.getNettyConfiguratorBuilder().serverOptions, this.getNettyConfiguratorBuilder().clientOptions, this.getNettyConfiguratorBuilder().handlerSuppliers);
            this.nettyConfiguratorBuilder = null;
        }
        return this.nettyConfigurator;
    }

    public NettyConfiguratorBuilder getNettyConfiguratorBuilder() {
        this.validateState();
        if (this.nettyConfiguratorBuilder == null) {
            this.nettyConfiguratorBuilder = new NettyConfiguratorBuilder();
        }
        return this.nettyConfiguratorBuilder;
    }

    public void validateState() {
        if (this.nettyConfigurator != null) {
            throw new IllegalStateException("Netty configurator already built! Any customizations must be done before building of the netty configurator!");
        }
    }

    public void reset() {
        this.nettyConfigurator = null;
        this.nettyConfiguratorBuilder = null;
    }

    static final class NettyConfigurator {
        private final Map<ChannelOption<?>, Object> serverOptions;
        private final Map<ChannelOption<?>, Object> clientOptions;
        private final List<Map.Entry<String, Supplier<ChannelHandler>>> handlerSuppliers;

        NettyConfigurator(Map<ChannelOption<?>, Object> serverOptions, Map<ChannelOption<?>, Object> clientOptions, List<Map.Entry<String, Supplier<ChannelHandler>>> handlerSuppliers) {
            this.serverOptions = serverOptions;
            this.clientOptions = clientOptions;
            this.handlerSuppliers = handlerSuppliers;
        }

        Map<ChannelOption<?>, Object> getServerOptions() {
            return this.serverOptions;
        }

        Map<ChannelOption<?>, Object> getClientOptions() {
            return this.clientOptions;
        }

        List<Map.Entry<String, Supplier<ChannelHandler>>> getHandlerSuppliers() {
            return this.handlerSuppliers;
        }
    }
}

