/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.AttributeKey;
import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Configs;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.netty.runtime.NettyRuntimeConfig;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.netty.internal.component.NettyConfiguratorController;
import io.rxmicro.rest.server.netty.internal.component.SharableNettyRequestHandler;
import io.rxmicro.rest.server.netty.internal.util.HealthCheckTools;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class NettyClientConnectionController
extends ChannelInitializer<SocketChannel> {
    private static final AttributeKey<Long> CHANNEL_TTL = AttributeKey.valueOf((String)"CHANNEL_TTL");
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClientConnectionController.class);
    private final RestServerConfig restServerConfig = (RestServerConfig)Configs.getConfig(RestServerConfig.class);
    private final NettyRuntimeConfig nettyRuntimeConfig = (NettyRuntimeConfig)Configs.getConfig(NettyRuntimeConfig.class);
    private final SharableNettyRequestHandler sharableNettyRequestHandler;
    private final List<Map.Entry<String, Supplier<ChannelHandler>>> handlerSuppliers;

    NettyClientConnectionController(SharableNettyRequestHandler sharableNettyRequestHandler) {
        this.sharableNettyRequestHandler = sharableNettyRequestHandler;
        this.handlerSuppliers = NettyConfiguratorController.getNettyConfiguratorController().getNettyConfigurator().getHandlerSuppliers();
    }

    protected void initChannel(SocketChannel ch) {
        boolean traceConnection;
        boolean bl = traceConnection = LOGGER.isTraceEnabled() && !HealthCheckTools.isHealthCheckToolAddress(this.restServerConfig, (Channel)ch);
        if (traceConnection) {
            ch.attr(CHANNEL_TTL).set((Object)System.nanoTime());
            LOGGER.trace("Client connection created: Channel=?, Socket=?", (Object)this.nettyRuntimeConfig.getChannelIdType().getId(ch.id()), (Object)ch.remoteAddress());
        }
        ChannelPipeline pipeline = ch.pipeline();
        for (Map.Entry<String, Supplier<ChannelHandler>> entry : this.handlerSuppliers) {
            pipeline.addLast(entry.getKey(), entry.getValue().get());
        }
        pipeline.addLast("nettyRxMicroRequestHandler", (ChannelHandler)this.sharableNettyRequestHandler);
        ch.closeFuture().addListener(future -> {
            if (traceConnection) {
                LOGGER.trace("Client connection closed: Channel=?, Socket=?, TTL=?", (Object)this.nettyRuntimeConfig.getChannelIdType().getId(ch.id()), (Object)ch.remoteAddress(), (Object)Formats.format((Duration)Duration.ofNanos(System.nanoTime() - (Long)ch.attr(CHANNEL_TTL).get())));
            }
        });
    }
}

