/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty.internal.component;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.rxmicro.config.Configs;
import io.rxmicro.rest.server.netty.NettyRestServerConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class InternalNettyConfiguratorBuilder {
    protected static final String NETTY_RX_MICRO_REQUEST_HANDLER_NAME = "nettyRxMicroRequestHandler";
    protected final Map<ChannelOption<?>, Object> serverOptions = new LinkedHashMap<ChannelOption, Integer>(Map.of(ChannelOption.SO_BACKLOG, 128));
    protected final Map<ChannelOption<?>, Object> clientOptions = new LinkedHashMap();
    protected final List<Map.Entry<String, Supplier<ChannelHandler>>> handlerSuppliers = new ArrayList<Map.Entry<String, Supplier<ChannelHandler>>>(List.of(Map.entry("HttpServerCodec", this::createHttpServerCodec), Map.entry("HttpObjectAggregator", this::createHttpObjectAggregator)));

    private HttpServerCodec createHttpServerCodec() {
        NettyRestServerConfig config = (NettyRestServerConfig)Configs.getConfig(NettyRestServerConfig.class);
        return new HttpServerCodec(config.getMaxHttpRequestInitialLineLength(), config.getMaxHttpRequestHeaderSize(), config.getMaxHttpRequestChunkSize(), config.isValidateHttpRequestHeaders(), config.getInitialHttpRequestBufferSize(), config.isAllowDuplicateHttpRequestContentLengths());
    }

    private HttpObjectAggregator createHttpObjectAggregator() {
        NettyRestServerConfig config = (NettyRestServerConfig)Configs.getConfig(NettyRestServerConfig.class);
        return new HttpObjectAggregator(config.getMaxHttpRequestContentLength(), config.isCloseOnHttpRequestContentExpectationFailed());
    }
}

