/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.server.netty.internal.component.InternalNettyConfiguratorBuilder;
import io.rxmicro.rest.server.netty.internal.component.NettyConfiguratorController;
import java.util.Map;
import java.util.function.Supplier;

public final class NettyConfiguratorBuilder
extends InternalNettyConfiguratorBuilder {
    public <T> NettyConfiguratorBuilder setServerOption(ChannelOption<T> option, T value) {
        NettyConfiguratorController.getNettyConfiguratorController().validateState();
        this.serverOptions.put((ChannelOption)Requires.require(option), Requires.require(value));
        return this;
    }

    public <T> NettyConfiguratorBuilder setClientOption(ChannelOption<T> option, T value) {
        NettyConfiguratorController.getNettyConfiguratorController().validateState();
        this.clientOptions.put((ChannelOption)Requires.require(option), Requires.require(value));
        return this;
    }

    public NettyConfiguratorBuilder resetChannelHandlers() {
        NettyConfiguratorController.getNettyConfiguratorController().validateState();
        this.handlerSuppliers.clear();
        return this;
    }

    public NettyConfiguratorBuilder addChannelHandlerSupplierToLastPosition(String name, Supplier<ChannelHandler> channelHandlerSupplier) {
        NettyConfiguratorController.getNettyConfiguratorController().validateState();
        for (Map.Entry entry : this.handlerSuppliers) {
            if (!((String)entry.getKey()).equals(name) && !"nettyRxMicroRequestHandler".equals(name)) continue;
            throw new IllegalArgumentException(Formats.format((String)"Channel handler with name='?' already defined!", (Object[])new Object[]{name}));
        }
        this.handlerSuppliers.add(Map.entry(name, channelHandlerSupplier));
        return this;
    }
}

