/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client.detail;

import io.rxmicro.config.Configs;
import io.rxmicro.rest.client.RestClientConfig;
import io.rxmicro.rest.client.detail.HttpClient;
import io.rxmicro.rest.client.internal.HttpClientLoggerHelper;
import io.rxmicro.rest.client.internal.RestClientBuilder;
import io.rxmicro.runtime.AutoRelease;
import io.rxmicro.runtime.local.InstanceContainer;
import java.util.function.BiFunction;

public final class RestClientImplFactory {
    private static final RestClientBuilder BUILDER = new RestClientBuilder();

    public static <T, C extends RestClientConfig> T createRestClient(String namespace, Class<C> configClass, Class<?> restClientInterface, BiFunction<HttpClient, C, T> creator) {
        RestClientConfig config = (RestClientConfig)Configs.getConfig((String)namespace, configClass);
        HttpClient httpClient = BUILDER.createHttpClient(restClientInterface, namespace, config);
        HttpClientLoggerHelper.logClientConfig(restClientInterface, httpClient, config);
        InstanceContainer.registerAutoRelease((AutoRelease)httpClient);
        return creator.apply(httpClient, (C)((Object)config));
    }

    private RestClientImplFactory() {
    }

    static {
        new Configs.Builder().buildIfNotConfigured();
    }
}

