/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client.detail;

import io.rxmicro.common.util.Exceptions;
import io.rxmicro.rest.client.detail.HttpClientCallFailedException;
import io.rxmicro.rest.client.detail.HttpResponse;
import java.util.function.BiFunction;

public final class ErrorResponseCheckerHelper {
    private static final int MIN_SUPPORTED_SUCCESS_CODE = 200;
    private static final int MAX_SUPPORTED_SUCCESS_CODE = 299;
    private static final BiFunction<HttpResponse, Throwable, HttpResponse> BI_FUNCTION = (clientHttpResponse, throwable) -> {
        if (throwable != null) {
            return (HttpResponse)Exceptions.reThrow((Throwable)throwable);
        }
        int status = clientHttpResponse.getStatusCode();
        if (status >= 200 && status <= 299) {
            return clientHttpResponse;
        }
        throw new HttpClientCallFailedException((HttpResponse)clientHttpResponse);
    };

    public static BiFunction<HttpResponse, Throwable, HttpResponse> throwExceptionIfNotSuccess() {
        return BI_FUNCTION;
    }

    private ErrorResponseCheckerHelper() {
    }
}

