/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Secrets;
import io.rxmicro.http.ProtocolSchema;
import io.rxmicro.rest.client.HttpClientConnectionPoolConfig;
import io.rxmicro.rest.client.LeasingStrategy;
import java.time.Duration;

public class RestClientConfig
extends HttpClientConnectionPoolConfig {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(3L);
    public static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(7L);
    private String accessKey;
    private boolean followRedirects;
    private boolean enableAdditionalValidations;
    private Duration connectTimeout;
    private Duration requestTimeout;

    public RestClientConfig() {
        super.setSchema(ProtocolSchema.HTTP);
        super.setHost("localhost");
        super.setPort(80);
        this.followRedirects = true;
        this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        this.requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public RestClientConfig setAccessKey(String accessKey) {
        this.accessKey = (String)Requires.require((Object)accessKey);
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public RestClientConfig setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public RestClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public RestClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = (Duration)Requires.require((Object)requestTimeout);
        return this;
    }

    public boolean isEnableAdditionalValidations() {
        return this.enableAdditionalValidations;
    }

    public RestClientConfig setEnableAdditionalValidations(boolean enableAdditionalValidations) {
        this.enableAdditionalValidations = enableAdditionalValidations;
        return this;
    }

    public RestClientConfig setSchema(ProtocolSchema schema) {
        return (RestClientConfig)super.setSchema(schema);
    }

    public RestClientConfig setHost(String host) {
        return (RestClientConfig)super.setHost(host);
    }

    public RestClientConfig setPort(int port) {
        return (RestClientConfig)super.setPort(port);
    }

    public RestClientConfig setConnectionString(String connectionString) {
        return (RestClientConfig)super.setConnectionString(connectionString);
    }

    @Override
    public RestClientConfig setEvictionInterval(Duration evictionInterval) {
        return (RestClientConfig)super.setEvictionInterval(evictionInterval);
    }

    @Override
    public RestClientConfig setMaxConnections(int maxConnections) {
        return (RestClientConfig)super.setMaxConnections(maxConnections);
    }

    @Override
    public RestClientConfig setPendingAcquireMaxCount(int pendingAcquireMaxCount) {
        return (RestClientConfig)super.setPendingAcquireMaxCount(pendingAcquireMaxCount);
    }

    @Override
    public RestClientConfig setPendingAcquireTimeout(Duration pendingAcquireTimeout) {
        return (RestClientConfig)super.setPendingAcquireTimeout(pendingAcquireTimeout);
    }

    @Override
    public RestClientConfig setMaxIdleTime(Duration maxIdleTime) {
        return (RestClientConfig)super.setMaxIdleTime(maxIdleTime);
    }

    @Override
    public RestClientConfig setMaxLifeTime(Duration maxLifeTime) {
        return (RestClientConfig)super.setMaxLifeTime(maxLifeTime);
    }

    @Override
    public RestClientConfig setLeasingStrategy(LeasingStrategy leasingStrategy) {
        return (RestClientConfig)super.setLeasingStrategy(leasingStrategy);
    }

    @Override
    public String toString() {
        return "RestClientConfig{connectionString=" + this.getConnectionString() + ", accessKey='" + Secrets.hideSecretInfo((String)this.accessKey) + "', followRedirects=" + this.followRedirects + ", connectTimeout=" + Formats.format((Duration)this.connectTimeout) + ", requestTimeout=" + Formats.format((Duration)this.requestTimeout) + ", enableAdditionalValidations=" + this.enableAdditionalValidations + ", evictionInterval=" + this.getEvictionInterval() + ", maxConnections=" + this.getMaxConnections() + ", pendingAcquireMaxCount=" + this.getPendingAcquireMaxCount() + ", pendingAcquireTimeout=" + this.getPendingAcquireTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", maxLifeTime=" + this.getMaxLifeTime() + ", leasingStrategy=" + this.getLeasingStrategy() + "}";
    }
}

