/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client;

import io.rxmicro.common.util.Requires;
import io.rxmicro.http.HttpConfig;
import io.rxmicro.rest.client.LeasingStrategy;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

public class HttpClientConnectionPoolConfig
extends HttpConfig {
    public static final int DEFAULT_POOL_MAX_CONNECTIONS = Math.max(Runtime.getRuntime().availableProcessors(), 8) * 2;
    public static final Duration DEFAULT_POOL_ACQUIRE_TIMEOUT = Duration.ofSeconds(45L);
    public static final Duration EVICT_IN_BACKGROUND_DISABLED = Duration.ZERO;
    public static final LeasingStrategy DEFAULT_POOL_LEASING_STRATEGY = LeasingStrategy.FIFO;
    private static final int PENDING_ACQUIRE_MAX_COUNT_NOT_SPECIFIED = -2;
    private Duration evictionInterval = EVICT_IN_BACKGROUND_DISABLED;
    private int maxConnections = DEFAULT_POOL_MAX_CONNECTIONS;
    private int pendingAcquireMaxCount = -2;
    private Duration pendingAcquireTimeout = DEFAULT_POOL_ACQUIRE_TIMEOUT;
    private Duration maxIdleTime;
    private Duration maxLifeTime;
    private LeasingStrategy leasingStrategy = DEFAULT_POOL_LEASING_STRATEGY;

    protected HttpClientConnectionPoolConfig() {
    }

    public Duration getEvictionInterval() {
        return this.evictionInterval;
    }

    public HttpClientConnectionPoolConfig setEvictionInterval(Duration evictionInterval) {
        this.evictionInterval = (Duration)Requires.require((Object)evictionInterval);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public HttpClientConnectionPoolConfig setMaxConnections(int maxConnections) {
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max Connections value must be strictly positive");
        }
        this.maxConnections = maxConnections;
        return this;
    }

    public OptionalInt getPendingAcquireMaxCount() {
        if (this.pendingAcquireMaxCount == -2) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.pendingAcquireMaxCount);
    }

    public HttpClientConnectionPoolConfig setPendingAcquireMaxCount(int pendingAcquireMaxCount) {
        if (pendingAcquireMaxCount != -1 && pendingAcquireMaxCount <= 0) {
            throw new IllegalArgumentException("Pending acquire max count must be strictly positive");
        }
        this.pendingAcquireMaxCount = pendingAcquireMaxCount;
        return this;
    }

    public Duration getPendingAcquireTimeout() {
        return this.pendingAcquireTimeout;
    }

    public HttpClientConnectionPoolConfig setPendingAcquireTimeout(Duration pendingAcquireTimeout) {
        this.pendingAcquireTimeout = (Duration)Requires.require((Object)pendingAcquireTimeout);
        return this;
    }

    public Optional<Duration> getMaxIdleTime() {
        return Optional.ofNullable(this.maxIdleTime);
    }

    public HttpClientConnectionPoolConfig setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = (Duration)Requires.require((Object)maxIdleTime);
        return this;
    }

    public Optional<Duration> getMaxLifeTime() {
        return Optional.ofNullable(this.maxLifeTime);
    }

    public HttpClientConnectionPoolConfig setMaxLifeTime(Duration maxLifeTime) {
        this.maxLifeTime = (Duration)Requires.require((Object)maxLifeTime);
        return this;
    }

    public LeasingStrategy getLeasingStrategy() {
        return this.leasingStrategy;
    }

    public HttpClientConnectionPoolConfig setLeasingStrategy(LeasingStrategy leasingStrategy) {
        this.leasingStrategy = (LeasingStrategy)((Object)Requires.require((Object)((Object)leasingStrategy)));
        return this;
    }

    public String toString() {
        return "HttpClientConnectionPoolConfig{evictionInterval=" + this.evictionInterval + ", maxConnections=" + this.maxConnections + ", pendingAcquireMaxCount=" + this.pendingAcquireMaxCount + ", pendingAcquireTimeout=" + this.pendingAcquireTimeout + ", maxIdleTime=" + this.maxIdleTime + ", maxLifeTime=" + this.maxLifeTime + ", leasingStrategy=" + this.leasingStrategy + "}";
    }
}

