/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client.jdk.internal;

import io.rxmicro.common.InvalidStateException;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.HttpVersion;
import io.rxmicro.rest.client.detail.HttpResponse;
import io.rxmicro.rest.client.jdk.internal.JdkHttpHeaders;
import java.net.http.HttpClient;
import java.util.function.Function;

final class JdkHttpResponse
implements HttpResponse {
    private final java.net.http.HttpResponse<byte[]> response;
    private final Function<byte[], Object> responseBodyConverter;
    private JdkHttpHeaders jdkHttpHeaders;

    JdkHttpResponse(java.net.http.HttpResponse<byte[]> response, Function<byte[], Object> responseBodyConverter) {
        this.response = response;
        this.responseBodyConverter = responseBodyConverter;
    }

    public int getStatusCode() {
        return this.response.statusCode();
    }

    public HttpVersion getVersion() {
        if (this.response.version() == HttpClient.Version.HTTP_1_1) {
            return HttpVersion.HTTP_1_1;
        }
        if (this.response.version() == HttpClient.Version.HTTP_2) {
            return HttpVersion.HTTP_2;
        }
        throw new InvalidStateException("Unsupported HTTP version: ?", new Object[]{this.response.version()});
    }

    public HttpHeaders getHeaders() {
        if (this.jdkHttpHeaders == null) {
            this.jdkHttpHeaders = new JdkHttpHeaders(this.response.headers());
        }
        return this.jdkHttpHeaders;
    }

    public boolean isBodyEmpty() {
        return this.response.body().length == 0;
    }

    public Object getBody() {
        return this.responseBodyConverter.apply(this.response.body());
    }

    public byte[] getBodyAsBytes() {
        return this.response.body();
    }
}

