/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client.jdk.internal;

import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Secrets;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

final class JdkHttpClientLogger {
    private final Logger logger;
    private final Secrets secrets;

    JdkHttpClientLogger(Class<?> loggerClass, Secrets secrets) {
        this.logger = LoggerFactory.getLogger(loggerClass);
        this.secrets = secrets;
    }

    boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    CompletableFuture<HttpResponse<byte[]>> trace(HttpRequest request, byte[] requestBody, CompletableFuture<HttpResponse<byte[]>> response) {
        String requestId = request.headers().firstValue("Request-Id").orElse("null");
        long startTime = System.nanoTime();
        this.logger.trace(() -> requestId, "HTTP request sent:\n? ?\n?\n\n?", (Object)Formats.format((String)"? ?", (Object[])new Object[]{request.method(), this.secrets.hideAllSecretsIn(request.uri().toString())}), (Object)request.version().map(Enum::toString).orElse(""), (Object)request.headers().map().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> Map.entry((String)e.getKey(), v))).map(e -> Formats.format((String)"?: ?", (Object[])new Object[]{e.getKey(), this.secrets.hideIfSecret((String)e.getValue())})).collect(Collectors.joining(System.lineSeparator())), (Object)(requestBody != null ? this.secrets.hideAllSecretsIn(new String(requestBody, StandardCharsets.UTF_8)) : ""));
        return response.whenComplete((resp, th) -> {
            if (resp != null) {
                this.logger.trace(() -> requestId, "HTTP response received (Duration=?):\n? ?\n?\n\n?", (Object)Formats.format((Duration)Duration.ofNanos(System.nanoTime() - startTime)), (Object)resp.version(), (Object)resp.statusCode(), (Object)resp.headers().map().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> Map.entry((String)e.getKey(), v))).map(e -> Formats.format((String)"?: ?", (Object[])new Object[]{e.getKey(), this.secrets.hideIfSecret((String)e.getValue())})).collect(Collectors.joining(System.lineSeparator())), (Object)(((byte[])resp.body()).length > 0 ? this.secrets.hideAllSecretsIn(new String((byte[])resp.body(), StandardCharsets.UTF_8)) : ""));
            }
        });
    }

    boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    CompletableFuture<HttpResponse<byte[]>> debug(HttpRequest request, byte[] requestBody, CompletableFuture<HttpResponse<byte[]>> response) {
        String requestId = request.headers().firstValue("Request-Id").orElse("null");
        String uri = request.uri().toString();
        long startTime = System.nanoTime();
        this.logger.debug(() -> requestId, "HTTP request sent: '?'?", (Object)Formats.format((String)"? ?", (Object[])new Object[]{request.method(), uri}), (Object)(requestBody == null ? "" : Formats.format((String)" with ? request body bytes", (Object[])new Object[]{requestBody.length})));
        return response.whenComplete((resp, th) -> {
            if (resp != null) {
                this.logger.debug(() -> requestId, "HTTP response received (Duration=?): '?/?', Content=? bytes", (Object)Formats.format((Duration)Duration.ofNanos(System.nanoTime() - startTime)), (Object)resp.statusCode(), (Object)resp.version(), (Object)((byte[])resp.body()).length);
            }
        });
    }
}

