/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.client.jdk.internal;

import io.rxmicro.common.util.Exceptions;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Secrets;
import io.rxmicro.rest.client.HttpClientTimeoutException;
import io.rxmicro.rest.client.RestClientConfig;
import io.rxmicro.rest.client.detail.HttpClient;
import io.rxmicro.rest.client.detail.HttpClientContentConverter;
import io.rxmicro.rest.client.detail.HttpResponse;
import io.rxmicro.rest.client.jdk.internal.JdkHttpClientLogger;
import io.rxmicro.rest.client.jdk.internal.JdkHttpResponse;
import io.rxmicro.runtime.detail.RxMicroRuntime;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

final class JdkHttpClient
implements HttpClient {
    static final String DEFAULT_USER_AGENT = Formats.format((String)"?-jdk-http-client/?", (Object[])new Object[]{"rx-micro", RxMicroRuntime.getRxMicroVersion()});
    private final JdkHttpClientLogger logger;
    private final RestClientConfig config;
    private final java.net.http.HttpClient client;
    private final String connectionString;
    private final String contentType;
    private final Function<Object, byte[]> requestBodyConverter;
    private final Function<byte[], Object> responseBodyConverter;

    JdkHttpClient(Class<?> loggerClass, RestClientConfig config, Secrets secrets, HttpClientContentConverter contentConverter) {
        this.config = config;
        this.logger = new JdkHttpClientLogger(loggerClass, secrets);
        this.connectionString = config.getConnectionString();
        this.contentType = (String)Requires.require((Object)contentConverter.getContentType());
        this.requestBodyConverter = (Function)Requires.require((Object)contentConverter.getRequestContentConverter());
        this.responseBodyConverter = (Function)Requires.require((Object)contentConverter.getResponseContentConverter());
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().followRedirects(config.isFollowRedirects() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        if (!config.getConnectTimeout().isZero()) {
            builder.connectTimeout(config.getConnectTimeout());
        }
        this.client = builder.build();
    }

    public CompletableFuture<HttpResponse> sendAsync(String method, String path, List<Map.Entry<String, String>> headers) {
        HttpRequest request = this.newRequestBuilder(path, headers, false).method(method, HttpRequest.BodyPublishers.noBody()).build();
        return this.send(request, null);
    }

    public CompletableFuture<HttpResponse> sendAsync(String method, String path, List<Map.Entry<String, String>> headers, Object body) {
        byte[] requestBody = this.requestBodyConverter.apply(body);
        HttpRequest request = this.newRequestBuilder(path, headers, true).method(method, HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
        return this.send(request, requestBody);
    }

    private HttpRequest.Builder newRequestBuilder(String path, List<Map.Entry<String, String>> headers, boolean withBody) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.connectionString + path)).version(HttpClient.Version.HTTP_1_1);
        this.setHeaders(requestBuilder, headers, withBody);
        if (!this.config.getRequestTimeout().isZero()) {
            requestBuilder.timeout(this.config.getRequestTimeout());
        }
        return requestBuilder;
    }

    private void setHeaders(HttpRequest.Builder requestBuilder, List<Map.Entry<String, String>> headers, boolean withBody) {
        if (!headers.isEmpty()) {
            TreeSet addedHeaders = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            headers.forEach(e -> {
                addedHeaders.add((String)e.getKey());
                requestBuilder.header((String)e.getKey(), (String)e.getValue());
            });
            if (!addedHeaders.contains("Accept")) {
                requestBuilder.header("Accept", this.contentType);
            }
            if (withBody && !addedHeaders.contains("Content-Type")) {
                requestBuilder.header("Content-Type", this.contentType);
            }
            if (!addedHeaders.contains("User-Agent")) {
                requestBuilder.header("User-Agent", DEFAULT_USER_AGENT);
            }
        } else {
            requestBuilder.header("Accept", this.contentType);
            if (withBody) {
                requestBuilder.header("Content-Type", this.contentType);
            }
            requestBuilder.header("User-Agent", DEFAULT_USER_AGENT);
        }
    }

    private CompletableFuture<HttpResponse> send(HttpRequest request, byte[] requestBody) {
        CompletableFuture<java.net.http.HttpResponse<byte[]>> response = this.client.sendAsync(request, this.ofByteArray());
        if (this.logger.isTraceEnabled()) {
            response = this.logger.trace(request, requestBody, response);
        } else if (this.logger.isDebugEnabled()) {
            response = this.logger.debug(request, requestBody, response);
        }
        return ((CompletableFuture)response.handle((resp, throwable) -> {
            if (throwable != null) {
                if (Exceptions.isInstanceOf((Throwable)throwable, HttpTimeoutException.class)) {
                    throw new HttpClientTimeoutException("HTTP connect timed out to ?", new Object[]{request.uri()});
                }
                Exceptions.reThrow((Throwable)throwable);
            }
            return resp;
        })).thenApply(resp -> new JdkHttpResponse((java.net.http.HttpResponse<byte[]>)resp, this.responseBodyConverter));
    }

    private HttpResponse.BodyHandler<byte[]> ofByteArray() {
        return responseInfo -> HttpResponse.BodySubscribers.ofByteArray();
    }

    public void release() {
    }
}

