/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.model;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.util.Strings;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum MappingStrategy {
    LOWERCASE_WITH_UNDERSCORED("_"),
    LOWERCASE_WITH_HYPHEN("-"),
    LOWERCASE_WITH_SPACE_CHARACTER(" "),
    UPPERCASE_WITH_UNDERSCORED("_"),
    UPPERCASE_WITH_HYPHEN("-"),
    UPPERCASE_WITH_SPACE_CHARACTER(" "),
    CAPITALIZE_WITH_UNDERSCORED("_"),
    CAPITALIZE_WITH_HYPHEN("-"),
    CAPITALIZE_CAMEL_CASE("");

    private final String delimiter;

    private MappingStrategy(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getModelName(List<String> words) {
        return words.stream().map(this::convert).filter(v -> !v.trim().isEmpty()).collect(Collectors.joining(this.delimiter));
    }

    public String getModelName(String camelCaseName) {
        return this.getModelName(Strings.splitByCamelCase((String)camelCaseName));
    }

    private String convert(String word) {
        if (this.name().startsWith("LOWERCASE")) {
            return word.toLowerCase(Locale.ENGLISH);
        }
        if (this.name().startsWith("UPPERCASE")) {
            return word.toUpperCase(Locale.ENGLISH);
        }
        if (this.name().startsWith("CAPITALIZE")) {
            return Strings.capitalize((String)word);
        }
        throw new ImpossibleException("Undefined mapping strategy group: '?'!", new Object[]{this.name()});
    }
}

