/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http.local;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;

public final class QueryParamUtils {
    private static final int DEFAULT_PATH_BUILDER_CAPACITY = 50;

    public static String joinPath(String path, Collection<Map.Entry<String, String>> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return path;
        }
        int delimiter = path.contains("?") ? 38 : 63;
        StringBuilder stringBuilder = new StringBuilder(50).append(path);
        for (Map.Entry<String, String> entry : parameters) {
            stringBuilder.append((char)delimiter).append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            if (delimiter != 63) continue;
            delimiter = 38;
        }
        return stringBuilder.toString();
    }

    private QueryParamUtils() {
    }
}

