/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http.local;

import io.rxmicro.common.util.Formats;

public final class HttpValidators {
    private static final String PROHIBITED_HEADERS_CHARACTERS = "\t\n\f\r ,:;=";
    private static final String PROHIBITED_QUERY_PARAMETERS_CHARACTERS = "\t\n\f\r ?&=";
    private static final int NULL = 0;
    private static final int VERTICAL_TAB = 11;
    private static final int MAX_ASCII_CODE = 127;

    public static String validateHeaderName(String headerName) {
        for (int i = 0; i < headerName.length(); ++i) {
            HttpValidators.validateNameCharacter("header", headerName, PROHIBITED_HEADERS_CHARACTERS, headerName.charAt(i));
        }
        return headerName;
    }

    public static String validateParameterName(String queryParameter) {
        for (int i = 0; i < queryParameter.length(); ++i) {
            HttpValidators.validateNameCharacter("parameter", queryParameter, PROHIBITED_QUERY_PARAMETERS_CHARACTERS, queryParameter.charAt(i));
        }
        return queryParameter;
    }

    public static void validateQueryParameterNameCharacter(char value) {
        HttpValidators.validateNameCharacter("query parameter or value", "", PROHIBITED_QUERY_PARAMETERS_CHARACTERS, value);
    }

    private static void validateNameCharacter(String type, String name, String prohibitedCharacters, char value) {
        if (value == '\u0000' || value == '\u000b' || prohibitedCharacters.indexOf(value) != -1) {
            throw new IllegalArgumentException(Formats.format((String)"A ? name ?cannot contain the following prohibited characters: ?", (Object[])new Object[]{type, name.isEmpty() ? name : Formats.format((String)"'?' ", (Object[])new Object[]{name}), HttpValidators.toString(prohibitedCharacters)}));
        }
        if (value > '\u007f') {
            throw new IllegalArgumentException(Formats.format((String)"A ? name ?cannot contain non-ASCII character: '?'", (Object[])new Object[]{type, name.isEmpty() ? name : Formats.format((String)"'?' ", (Object[])new Object[]{name}), Character.valueOf(value)}));
        }
    }

    private static String toString(String prohibitedCharacters) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < prohibitedCharacters.length(); ++i) {
            char ch = prohibitedCharacters.charAt(i);
            if (ch == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (ch == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (ch == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (ch == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private HttpValidators() {
    }
}

