/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http.local;

import io.rxmicro.common.util.Formats;
import io.rxmicro.http.local.RepeatableValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractRepeatableValues<T extends RepeatableValues<T>> {
    private final Map<String, Object> valuesMap = new LinkedHashMap<String, Object>();

    protected AbstractRepeatableValues() {
    }

    protected AbstractRepeatableValues(T other) {
        this();
        this.setOrAddAll(other);
    }

    public final boolean contains(String name) {
        return this.valuesMap.containsKey(name);
    }

    public final boolean isEmpty() {
        return this.valuesMap.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.valuesMap.isEmpty();
    }

    public final int size() {
        return this.valuesMap.size();
    }

    public final Set<String> names() {
        return this.valuesMap.keySet();
    }

    public final boolean remove(String name) {
        return this.valuesMap.remove(name) != null;
    }

    public final void clear() {
        this.valuesMap.clear();
    }

    public final String getValue(String name) {
        Object value = this.valuesMap.get(name);
        if (value == null) {
            return null;
        }
        if (this.isSetValue(value)) {
            return (String)value;
        }
        return (String)((List)value).get(0);
    }

    public final List<String> getValues(String name) {
        Object value = this.valuesMap.get(name);
        if (value == null) {
            return List.of();
        }
        if (this.isAddedValue(value)) {
            return (List)value;
        }
        return Collections.singletonList((String)value);
    }

    public final void add(String name, String value) {
        ListImpl values = new ListImpl(value);
        Object oldValue = this.valuesMap.put(name, values);
        if (oldValue != null) {
            if (this.isSetValue(oldValue)) {
                values.add(0, (String)oldValue);
            } else {
                ((List)oldValue).add(value);
                this.valuesMap.put(name, oldValue);
            }
        }
    }

    public final void set(String name, String value) {
        this.valuesMap.put(name, value);
    }

    public final void setOrAdd(String name, String value) {
        Object oldValue = this.valuesMap.put(name, value);
        if (oldValue != null) {
            if (this.isSetValue(oldValue)) {
                this.valuesMap.put(name, new ListImpl((String)oldValue, value));
            } else {
                ((List)oldValue).add(value);
                this.valuesMap.put(name, oldValue);
            }
        }
    }

    public final void setOrAddAll(T other) {
        for (Map.Entry<String, Object> entry : other.getValuesMap().entrySet()) {
            if (!this.isSetValue(entry.getValue()) && !this.isAddedValue(entry.getValue())) {
                throw new IllegalArgumentException("Unsupported type: " + entry.getValue().getClass());
            }
            if (this.valuesMap.containsKey(entry.getKey())) {
                Object oldValue = this.valuesMap.get(entry.getKey());
                Object newValue = entry.getValue();
                if (this.isAddedValue(oldValue)) {
                    if (this.isAddedValue(newValue)) {
                        ((List)oldValue).addAll((List)newValue);
                        continue;
                    }
                    this.valuesMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (this.isAddedValue(newValue)) {
                    ListImpl mergeValues = new ListImpl((String)oldValue);
                    mergeValues.addAll((List)newValue);
                    this.valuesMap.put(entry.getKey(), mergeValues);
                    continue;
                }
                this.valuesMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.valuesMap.put(entry.getKey(), entry.getValue());
        }
    }

    public final List<Map.Entry<String, String>> getEntries() {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>(this.valuesMap.size());
        for (Map.Entry<String, Object> entry : this.valuesMap.entrySet()) {
            if (this.isAddedValue(entry.getValue())) {
                for (String value : (List)entry.getValue()) {
                    result.add(Map.entry(entry.getKey(), value));
                }
                continue;
            }
            result.add(Map.entry(entry.getKey(), (String)entry.getValue()));
        }
        return Collections.unmodifiableList(result);
    }

    public final Map<String, Object> getValuesMap() {
        return this.valuesMap;
    }

    public final boolean isAddedValue(Object value) {
        return value instanceof List;
    }

    public final boolean isSetValue(Object value) {
        return value instanceof String;
    }

    public String toString() {
        return this.getEntries().stream().map(e -> Formats.format((String)"?=?", (Object[])new Object[]{e.getKey(), e.getValue()})).collect(Collectors.joining(";"));
    }

    private static final class ListImpl
    extends ArrayList<String> {
        private ListImpl(String value) {
            super(1);
            this.add(value);
        }

        private ListImpl(String value1, String value2) {
            super(2);
            this.add(value1);
            this.add(value2);
        }
    }
}

