/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.http.internal;

import io.rxmicro.config.ConfigException;
import io.rxmicro.http.HttpConfig;
import io.rxmicro.http.ProtocolSchema;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public final class HttpConfigExtractor {
    private static final String PROTOCOL_SEPARATOR = "://";

    public void extract(String connectionString, HttpConfig config) {
        StringBuilder connectionStringSource = new StringBuilder(connectionString);
        ProtocolSchema schema = this.getSchema(connectionStringSource);
        config.setSchema(schema).setHost(this.getHost(connectionStringSource)).setPort(this.getPort(schema, connectionStringSource));
    }

    private ProtocolSchema getSchema(StringBuilder connectionStringSource) {
        int index = connectionStringSource.indexOf(PROTOCOL_SEPARATOR);
        if (index == -1) {
            return ProtocolSchema.HTTP;
        }
        String schema = connectionStringSource.substring(0, index);
        connectionStringSource.delete(0, index + PROTOCOL_SEPARATOR.length());
        try {
            return ProtocolSchema.valueOf(schema.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ignore) {
            throw new ConfigException("Unsupported protocol schema: '?'! Only following schemas are supported: ?", new Object[]{schema, Arrays.stream(ProtocolSchema.values()).map(e -> e.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHost(StringBuilder connectionStringSource) {
        int index = connectionStringSource.indexOf(":");
        if (index == -1) {
            try {
                String string = connectionStringSource.toString();
                return string;
            }
            finally {
                connectionStringSource.delete(0, connectionStringSource.length());
            }
        }
        try {
            String string = connectionStringSource.substring(0, index);
            return string;
        }
        finally {
            connectionStringSource.delete(0, index + 1);
        }
    }

    private int getPort(ProtocolSchema schema, StringBuilder connectionStringSource) {
        if (connectionStringSource.length() == 0) {
            return schema.getPort();
        }
        try {
            return Integer.parseInt(connectionStringSource.toString());
        }
        catch (NumberFormatException ignore) {
            throw new ConfigException("Invalid port value: expected a number, but actual is '?'!", new Object[]{connectionStringSource.toString()});
        }
    }
}

